package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;

public class AutomatProbeklausurAutoGramTest {
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aba", "abb"
          ,"abaa","abababaa", "abba", "bab", "babb", "baba", "babababb" })
  public void testAutomatInGrammatik(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        A: a b
        Z: start Z1 Z2 Z3 Z4 Z5 Z6
        E: Z3 Z6
        S: start
        start /eps Z1
        start /eps Z4
        Z1 a Z2
        Z2 b Z1
        Z2 a Z3
        Z4 b Z5
        Z5 a Z4
        Z5 b Z6
        """);
    ea.deterministisch().minimieren();
    KontextfreieGrammatik ea2 = new KontextfreieGrammatik();
    ea2.dateiEinlesen(
        "beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "ProbeklausurAutoGram.kfg");
    Assertions.assertEquals(ea.akzeptieren(wort), ea2.ableitbar(wort)
        , util.Util.text(wort) + " wird nicht gleichbehandelt.");
  }
}
