package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;

public class AutomatProbeklausurGramAutoTest {
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aba", "abb"
          ,"abaa","abababaa", "abba", "bab", "babb", "baba", "babababb" })
  public void testAutomatInGrammatik(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen(
        "beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "ProbeklausurGramAuto.atm");
    ea.deterministisch().minimieren();
    KontextfreieGrammatik ea2 = new KontextfreieGrammatik();
    ea2.stringAlsGrammatik("""
        N: A B
        T: a b
        S: A
        A -> abaA | B | bbB            
        B-> b | /eps
        """);
    Assertions.assertEquals(ea.akzeptieren(wort), ea2.ableitbar(wort)
        , util.Util.text(wort) + " wird nicht gleichbehandelt.");
  }
}
