package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatProbeklausurMinimierung2Test {
  @Test
  public void testAutomatUeberfuehrungCdet() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" 
        + util.Util.FS + "ProbeklausurMinimierung2.atm");
    Assertions.assertTrue(ea.istDeterministisch(), "Automat ist nicht deterministisch.");
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        % Automat_vorMinimierungProbe
        Z: z0 z1 z2 z3 z4 z5
        E: z0 z1 z3 z4
        S: z0
        A: a b
        z0 a z1
        z0 b z2
        z1 a z3
        z1 b z4
        z2 a z2
        z2 b z2
        z3 a z3
        z3 b z4
        z4 a z2
        z4 b z5
        z5 a z2
        z5 b z4 
        """);
    ea2.deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
