package test.endlicherAutomat;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class OptimierungsTest {

  private static EndlicherAutomat prototyp;
  
  private static EndlicherAutomat optimiert;
  
  public static void init(String datei) {
    Nichtterminal.reset();
    Terminal.reset();
    prototyp = new EndlicherAutomat();
    
    // hier optimierte Version erzeugen
    optimiert = new EndlicherAutomat();
    
    prototyp.dateiEinlesen(datei);
    optimiert.dateiEinlesen(datei);
  }
  
  public static void main(String[] args) {
    if (checkBasics()) {
      // um Zeiten bei der Initialisierung nicht zu beachten
      // wird jede Analyse zunaechst ohne und dann mit Ergebnis
      //durchgefuehrt
      testOhneEpsilon(false);
      testOhneEpsilon(true);
      testDeterministisch(false);
      testDeterministisch(true);
      testMinimieren(false);
      testMinimieren(true);
    }
  }
  
  public static boolean checkBasics() {
    String reg = "((ab)*(ba)*)*";
    init("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatZurOptimierung1.atm");
    EndlicherAutomat ea = RegulaererAusdruck.alsAusdruck(reg).alsAutomat().deterministisch().minimieren();
    optimiert.epsilonEntfernen();
    if (!optimiert.getUeber().getEpsilon().isEmpty()) {
      System.out.println("darf keine Epsilon-Ueberfuehrung mehr geben"
          + " (ist in AutomatUeberfuehrungsfunktion");
    }
    
    EndlicherAutomat ea2 = optimiert.deepClone().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    if (!erg) {
      Wort w = ea.nichtGemeinsamesWort(ea2);
      System.out.println("nach Epsilon-Umformung wird Wort \"" + w 
          + "\" nicht wie in " + reg + " bearbeitet.");
      return false;
    }
 
    optimiert.deterministisch();
    if (!optimiert.istDeterministisch()) {
      System.out.println("Ergebnis ist nicht deterministisch:\n" + optimiert);
      return false;
    }
    
    ea2 = optimiert.deepClone().deterministisch().minimieren();
    erg = ea.istMinimalIsomorph(ea2);
    if (!erg) {
      Wort w = ea.nichtGemeinsamesWort(ea2);
      System.out.println("nach Deterministisch-Umformung wird Wort \"" + w 
          + "\" nicht wie in " + reg + " bearbeitet.");
      return false;
    }
    
    optimiert.deterministisch();
    if (!optimiert.istDeterministisch()) {
      System.out.println("Ergebnis ist nicht deterministisch:\n" + optimiert);
      return false;
    }
    
    ea2 = optimiert.deepClone().deterministisch().minimieren();
    erg = ea.istMinimalIsomorph(ea2);
    if (!erg) {
      Wort w = ea.nichtGemeinsamesWort(ea2);
      System.out.println("nach Deterministisch-Umformung wird Wort \"" + w 
          + "\" nicht wie in " + reg + " bearbeitet.");
      return false;
    }
    
    ea2 = optimiert.minimieren();
    erg = ea.istMinimalIsomorph(ea2);
    if (!erg) {
      Wort w = ea.nichtGemeinsamesWort(ea2);
      System.out.println("nach Minimierung wird Wort \"" + w 
          + "\" nicht wie in " + reg + " bearbeitet.");
      return false;
    }
    
    
    return true;
  }
   
  public static void testMinimieren(boolean zeigen) {
    if(zeigen) {
      System.out.println("minimieren Test:");
    }
    init("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatZurOptimierung4.atm");
    long start1 = System.currentTimeMillis();
    prototyp.minimieren();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.minimieren();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
  
  public static void testOhneEpsilon(boolean zeigen) {
    if(zeigen) {
      System.out.println("Ohne Epsilon Test:");
    }
    init("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatZurOptimierung2.atm");
    long start1 = System.currentTimeMillis();
    prototyp.epsilonEntfernen();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.epsilonEntfernen();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
  
  public static void testDeterministisch(boolean zeigen) {
    if(zeigen) {
      System.out.println("deterministisch Test:");
    }
    init("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatZurOptimierung3.atm");
    long start1 = System.currentTimeMillis();
    prototyp.deterministisch();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.deterministisch();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
}
