package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.Klammern;
import regulaererAusdruck.Leer;
import regulaererAusdruck.Oder;
import regulaererAusdruck.Punkt;
import regulaererAusdruck.RegulaererAusdruck;
import regulaererAusdruck.Stern;
import zustand.Zustand;

class RegulaererAusdruckTest {

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
  }

  @Test
  void testregulaerLeer() {
    RegulaererAusdruck reg = new Leer(); 
    Assertions.assertEquals("{}", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    Assertions.assertEquals(0, ea.getAlphabet().size());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
  }
  
  @Test
  void testregulaerZeichen() {
    Terminal x = Terminal.terminal("x");
    RegulaererAusdruck reg = x; 
    Assertions.assertEquals("x", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertEquals(1, ea.getAlphabet().size(), ea.getAlphabet().get(0).getClass() + " " + ea.getAlphabet().get(0).getClass() + "\n" + ea);
    Assertions.assertTrue(ea.akzeptieren("x"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xx"), ea.toString());
  }
  
  @Test
  void testregulaerKonkatenierenMitPunkt() {
    Terminal x = Terminal.terminal("x");
    Terminal y = Terminal.terminal("y");
    RegulaererAusdruck reg = new Punkt(x,y); 
    Assertions.assertEquals("xy", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertTrue(ea.getAlphabet().contains(y));
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("xy"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("x"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xyx"), ea.toString());
  }
  
  @Test
  void testregulaerAlternative() {
    Terminal x = Terminal.terminal("x");
    Terminal y = Terminal.terminal("y");
    RegulaererAusdruck reg = new Oder(x,y); 
    Assertions.assertEquals("(x + y)", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    System.out.println(ea);
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertTrue(ea.getAlphabet().contains(y));
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("x"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("y"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xy"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("yx"), ea.toString());
  }
  
  @Test
  void testregulaerKlammer() {
    Terminal x = Terminal.terminal("x");
    Terminal y = Terminal.terminal("y");
    RegulaererAusdruck reg = new Klammern(new Oder(x,y)); 
    Assertions.assertEquals("((x + y))", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    System.out.println(ea);
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertTrue(ea.getAlphabet().contains(y));
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("x"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("y"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xy"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("yx"), ea.toString());
  }
  
  @Test
  void testregulaerStern() {
    Terminal x = Terminal.terminal("x");
    Terminal y = Terminal.terminal("y");
    RegulaererAusdruck reg = new Stern(new Oder(x,y)); 
    Assertions.assertEquals("((x + y))*", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    //System.out.println(ea);
    //ea.epsilonEntfernen();
    //System.out.println("------------ohneeps\n" + ea);
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertTrue(ea.getAlphabet().contains(y));
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("x"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("y"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren(""), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("xy"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("yxxxxxxxy"), ea.toString());
  }
  
  @Test
  void testregulaerMix() {
    Terminal x = Terminal.terminal("x");
    Terminal y = Terminal.terminal("y");
    RegulaererAusdruck reg = new Stern(new Oder(new Punkt(x,x,x),new Punkt(y,y,y))); 
    Assertions.assertEquals("((xxx + yyy))*", reg.toString());
    EndlicherAutomat ea = reg.alsAutomat();
    //System.out.println(ea);
    //ea.epsilonEntfernen();
    //System.out.println("------------ohneeps\n" + ea);
    Assertions.assertTrue(ea.getAlphabet().contains(x));
    Assertions.assertTrue(ea.getAlphabet().contains(y));
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("xxx"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("yyy"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren(""), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("xxxyyy"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("yyyxxx"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("x"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("y"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xx"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("yy"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xxxx"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("yyyy"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("xxxyxy"), ea.toString());
  }
  
  @Test
  void testregulaerMix2() {
    RegulaererAusdruck reg = RegulaererAusdruck.alsAusdruck("((b)*a(b)*(b)*a(b)*)*(b)*a(b)*", false);
    EndlicherAutomat ea = reg.alsAutomat();
    //System.out.println(ea);
    //ea.epsilonEntfernen();
    //System.out.println("------------ohneeps\n" + ea);
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("a"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("bbabb"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("bbabbabbabb"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("aaa"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("aaaaa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("bbabbabb"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("bbaabbaa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aabbaabb"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aaaaaa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("baaaaaab"), ea.toString());
  }
  
  @Test
  void testregulaerMix3() {
    RegulaererAusdruck reg = RegulaererAusdruck.alsAusdruck("(b)*a(b)*", false);
    EndlicherAutomat ea = reg.alsAutomat();
    //System.out.println(ea);
    //ea.epsilonEntfernen();
    //System.out.println("------------ohneeps\n" + ea);
    Assertions.assertEquals(2, ea.getAlphabet().size());
    Assertions.assertTrue(ea.akzeptieren("a"), ea.toString());
    Assertions.assertTrue(ea.akzeptieren("bbabb"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren(""), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("bbabbabb"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("bbaabbaa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aabbaabb"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("aaaaaa"), ea.toString());
    Assertions.assertFalse(ea.akzeptieren("baaaaaab"), ea.toString());
  }

}
