package test.kontextfreieGrammatik;

import java.util.ArrayList;
import java.util.List;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import ausfuehrung.Ableitung;
import ausfuehrung.Regelnutzung;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

class AbleitungTest {

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
  }
  
  @AfterEach
  public void tearDown() {
    Terminal.reset();
    Nichtterminal.reset();
  }

  @Test
  void testInLinksableitung1() {
    String grammatik =
        """
        N: A 
        T: a b c d e f g h i j k l +
        S: A
        r1:: A -> A+A 
        r2:: A -> abc | def | ghi | jkl 
        """;
    var sut = new KontextfreieGrammatik();
    sut.stringAlsGrammatik(grammatik);
   // var liste = sut.ausfuehren();
    List<Regelnutzung> liste = new ArrayList<Regelnutzung>();
    liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r2_3"), 6));
    liste.add(new Regelnutzung(sut.regelZuId("r2_1"), 2));
    liste.add(new Regelnutzung(sut.regelZuId("r2_0"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r2_2"), 8));

    Wort wort = new Wort(sut.getStart());
    for(var r:liste) {
      wort = r.anwenden(wort);
      //System.out.println(wort);
    }
    Assertions.assertEquals(sut.stringAlsWort("abc+def+ghi+jkl"), wort);
    
    Ableitung ab = new Ableitung(liste, true, wort);
    List<Regelnutzung> neu = ab.getSequenz();
    Assertions.assertEquals(sut.regelZuId("r1"), neu.get(0).getRegel());
    Assertions.assertEquals(sut.regelZuId("r1"), neu.get(1).getRegel());
    Assertions.assertEquals(sut.regelZuId("r1"), neu.get(2).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_0"), neu.get(3).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_1"), neu.get(4).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_2"), neu.get(5).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_3"), neu.get(6).getRegel());
  }

  @Test
  void testInLinksableitung2() {
    String grammatik =
        """
        N: A 
        T: a b c d e f g h i j k l +
        S: A
        r1:: A -> AAA 
        r2:: A -> abc | def | ghi | jkl | /eps 
        """;
    var sut = new KontextfreieGrammatik();
    sut.stringAlsGrammatik(grammatik);
   // var liste = sut.ausfuehren();
    List<Regelnutzung> liste = new ArrayList<Regelnutzung>();
    liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    //liste.add(new Regelnutzung(sut.regelZuId("r1"), 0));
    liste.add(new Regelnutzung(sut.regelZuId("r2_2"), 3));
    liste.add(new Regelnutzung(sut.regelZuId("r2_4"), 6));
    liste.add(new Regelnutzung(sut.regelZuId("r2_4"), 1));
    liste.add(new Regelnutzung(sut.regelZuId("r2_1"), 1));
    liste.add(new Regelnutzung(sut.regelZuId("r2_4"), 0));

    Wort wort = new Wort(sut.getStart());
    for(var r:liste) {
      wort = r.anwenden(wort);
      System.out.println(wort);
    }
    Assertions.assertEquals(sut.stringAlsWort("defghi"), wort);
    
    Ableitung ab = new Ableitung(liste, true, wort);
    List<Regelnutzung> neu = ab.getSequenz();
    wort = new Wort(sut.getStart());
    for(var r:neu) {
      System.out.println(r);
      wort = r.anwenden(wort);
      System.out.println(wort);
    }
    Assertions.assertEquals(sut.stringAlsWort("defghi"), wort);
    
    Assertions.assertEquals(sut.regelZuId("r1"), neu.get(0).getRegel());
    Assertions.assertEquals(sut.regelZuId("r1"), neu.get(1).getRegel());
    //Assertions.assertEquals(sut.regelZuId("r1"), neu.get(2).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_4"), neu.get(2).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_4"), neu.get(3).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_1"), neu.get(4).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_2"), neu.get(5).getRegel());
    Assertions.assertEquals(sut.regelZuId("r2_4"), neu.get(6).getRegel());
  }
}
