package test.kontextfreieGrammatik;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import alphabet.Terminal;
import alphabet.Wort;
import grammatik.KontextfreieGrammatik;

public class BeliebigeGrammatikAufErsterWortePruefen {
  
//  private static String gram = """
//      T: a b c
//      N: Start A B C
//      S: Start
//      Start -> aAbbBC            
//      A -> aA | /eps         
//      B-> bB | /eps        
//      C -> ccc | cc | c | /eps
//      """;
//  // Wiederholung ohne eps
//  private static String gram = """  
//      N: Start A B
//      T: a b
//      S: Start
//      Start -> aABb | aA          
//      A -> aaa | bBAa | B           
//      B -> ab | ba | /eps
//      """;
  
  //Wiederholung ohne Kette
  private static String gram = """  
      N: Start A B
      T: a b
      S: Start
      Start -> aABb | A          
      A -> aaa | bBAa | B           
      B -> ab | ba | Start
      """;
  
  public static List<Wort> bislaenge(int lang, Set<Terminal> term){
    List<Wort> erg = new ArrayList<>();
    erg.add(new Wort());
    for (int i=0; i < lang; i++) {
      List<Wort> neu = new ArrayList<>();
      for (Wort w:erg) {
        neu.add(w);
        if (w.laenge() == i) {
          for(Terminal t:term) {
            neu.add(w.clone().anfuegen(t));
          }
        }
      }
      erg = neu;
    }
    return erg;
  }
  
  public static String listeAlsArrayausgabe(List<Wort> liste) {
    StringBuffer sb = new StringBuffer("{");
    for(int i = 0; i < liste.size() - 1; i++) {
      sb.append("\"" + liste.get(i) + "\",");
    }
    if (!liste.isEmpty()) {
      sb.append("\"" + liste.get(liste.size() - 1) + "\"");
    }
    sb.append("}");
    return sb.toString();
  }

  public static void main(String[] args) {
    KontextfreieGrammatik sut = new KontextfreieGrammatik();
    sut.stringAlsGrammatik(gram);
    List<Wort> ok = new ArrayList<>();
    List<Wort> nok = new ArrayList<>();
    for(Wort w: bislaenge(6, sut.getTerminale())) {
      //System.out.println(w);
      if (sut.ableitbar(w.toString())) {
        ok.add(w);
      } else {
        nok.add(w);
      }
    }
    //System.out.println(bislaenge(3, sut.getTerminale()));
    System.out.println("ok " + ok.size() + "\n" + listeAlsArrayausgabe(ok));
    System.out.println("nok " + nok.size() + "\n" +  listeAlsArrayausgabe(nok));
  }

}
