package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;
import regulaererAusdruck.RegulaererAusdruck;
import zustand.Zustand;

public class GrammatikInAutomatTest {
  
  @BeforeEach
  public void setup() {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
  }
  
  @Test
  public void testIstRechtslinear1OK() {
    String grammatik =
        """
        N: AX BX
        T: a b 
        S: AX
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertTrue(g.istRechtslinear());
  }
  
  @Test
  public void testIstRechtslinear2OK() {
    String grammatik =
        """
        N: A B
        T: a b 
        S: A
        r1:: A -> a | aa | aaaA | aaB | B 
        r2:: B -> b | bbB
        r3:: B -> /eps
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertTrue(g.istRechtslinear());
  }
  
  @Test
  public void testIstRechtslinear1NOK() {
    String grammatik =
        """
        N: A B
        T: a b 
        S: A
        r1:: A -> a | aa | aaaA | aaB | B 
        r2:: B -> b | bbB | Bb
        r3:: B -> /eps
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertFalse(g.istRechtslinear());
  }
  
  @Test
  public void testIstRechtslinear2NOK() {
    String grammatik =
        """
        N: A B
        T: a b 
        S: A
        r1:: A -> a | aa | aaaA | aaB | B 
        r2:: B -> b | bbB | aaBb
        r3:: B -> /eps
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertFalse(g.istRechtslinear());
  }
  
  @Test
  public void testRechtslinearInAutomaten1() {
    String grammatik =
        """
        N: AX BX
        T: a b 
        S: AX
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    EndlicherAutomat ea = g.rechtslinearInAutomaten();
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck("ab{}").alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    if (!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
    }
    Assertions.assertTrue(erg, util.Util.text(w) + " nicht korrekt bearbeitet");
  }
  
  @Test
  public void testRechtslinearInAutomaten2() {
    String grammatik =
        """
        N: A B
        T: a b 
        S: A
        A -> aaA | B | aa 
        B -> bbB | bb | /eps
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    EndlicherAutomat ea = g.rechtslinearInAutomaten();
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck("(aa + ({})*)(aa)*(bb)*").alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    if (!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
    }
    Assertions.assertTrue(erg, util.Util.text(w) + " nicht korrekt bearbeitet");
  }
  
  @Test
  public void testRechtslinearInAutomatenNOK() {
    String grammatik =
        """
        N: A B
        T: a b 
        S: A
        r1:: A -> a | aa | aaaA | aaB | B 
        r2:: B -> b | bbB | Bb
        r3:: B -> /eps
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    try{
      g.rechtslinearInAutomaten();
      Assertions.fail("nicht rechtslineare Grammatik in Automaten umgeformt");
    } catch(IllegalStateException e) {
    }
  }
}
