package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class GrammatikOhneUnnoetigeRegelnTest {

  private KontextfreieGrammatik sut;
  
  @BeforeEach
  public void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    Nichtterminal.reset();
    Terminal.reset();
  }
  


  @Test
  public void testAlleUnnoetig() {
    String grammatik =
        """
        N: A B C D E F
        T: a b c 
        S: A
        r1:: A -> BC
        r2:: A -> CD
        r3:: D -> aEb
        r4:: F -> ab
        r5:: B -> bb
        r6:: C -> D
        r7:: D -> aA    
        """;
    sut.stringAlsGrammatik(grammatik);
    sut.loescheUnnoetigeRegeln();
    Assertions.assertTrue(sut.getRegeln().isEmpty()
        , "alle Regeln nicht nutzbar, gefunden: " + sut.getRegeln());
  }
  
  @Test
  public void testZweiUnnoetig() {
    String grammatik =
        """
        N: A B C D E F
        T: a b c 
        S: A
        r1:: A -> BC
        r2:: A -> CD
        r3:: D -> aEb
        r4:: F -> ab
        r5:: B -> bb
        r6:: C -> D
        r7:: D -> a    
        """;
    sut.stringAlsGrammatik(grammatik);
    sut.loescheUnnoetigeRegeln();
    Assertions.assertEquals(5, sut.getRegeln().size()
        , "nur 5 Regeln nutzbar, gefunden: " + sut.getRegeln());
    Assertions.assertTrue(this.regelVorhanden(sut, "r1"));
    Assertions.assertTrue(this.regelVorhanden(sut, "r2"));
    Assertions.assertTrue(this.regelVorhanden(sut, "r5"));
    Assertions.assertTrue(this.regelVorhanden(sut, "r6"));
    Assertions.assertTrue(this.regelVorhanden(sut, "r7"));
    Assertions.assertFalse(this.regelVorhanden(sut, "r3"));
    Assertions.assertFalse(this.regelVorhanden(sut, "r4"));
  }
  
  private boolean regelVorhanden(KontextfreieGrammatik g, String name) {
    try {
      g.regelZuId(name);
      return true;
    } catch(Exception e) {
      return false;
    }
  }

}
