package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class KFGInChomskyTest {
  private KontextfreieGrammatik sut;

  @BeforeEach
  public void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    this.sut.dateiEinlesen(
        "beispiele" + util.Util.FS + "kontextfreiegrammatiken" + util.Util.FS + "KFGInChomsky.kfg");
  }
  
  @Test
  public void testStruktur() {
    Assertions.assertTrue(this.sut.istInChomskyNormalform());
  }

  @ParameterizedTest
  @ValueSource(
      strings = { "ab", "abbab", "aaaaaaaab", "abaaaab", "aaaabab", "abbabbab"
          ,"aaaa", "aabbaabbaabba"})
  public void testOK(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(
      strings = { "", "aaa", "aaaaa", "b", "bbb", "aab", "aba"
          ,"aabbbaa", "aaabaaa", "bbaa"})
  public void testNicht(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte nicht ableitbar sein in\n");
  }
}


