package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;
import zustand.Zustand;

public class KFGOhneEpsWiederholungTest {
  private KontextfreieGrammatik sut;
  // Grammatik hier eingeben
  private String gram = """
      N: Start A B
      T: a b
      S: Start
      Start -> aABb | aA | aBb | aAb | ab | a         
      A -> aaa | bBAa | bBa | bAa | ba | B           
      B -> ab | ba 
      """;

  @BeforeEach
  public void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    this.sut.stringAlsGrammatik(gram);
  }
  
  @Test
  public void testStruktur() {
    for(KontextfreieRegel reg: this.sut.getRegeln()) {
      Assertions.assertFalse(reg.getRechts().laenge() == 0
          && reg.getLinks() != this.sut.getStart(), "nicht erlaubt: " + reg);
    }
  }

  @ParameterizedTest
  @ValueSource(
      strings = {"a","aaaa","aab","aabb","ab","aba","abab"})
  public void testOK(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(
      strings = {"","aa","aaa","aaab","aaba","abaa","abb","abba","abbb"
          ,"b","ba","baa","baaa","baab","bab","baba","babb","bb","bba"
          ,"bbaa","bbab","bbb","bbba","bbbb"})
  public void testNicht(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte nicht ableitbar sein in\n");
  }
}
