package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;
import zustand.Zustand;

public class KFGOhneKette2Test {
  private KontextfreieGrammatik sut;

  @BeforeEach
  public void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    this.sut.dateiEinlesen(
        "beispiele" + util.Util.FS + "kontextfreiegrammatiken" 
            + util.Util.FS + "KFGOhneKette2.kfg");
  }
  
  @Test
  public void testStruktur() {
    for(KontextfreieRegel reg: this.sut.getRegeln()) {
      Assertions.assertFalse(reg.getRechts().laenge() == 1 
          && reg.getRechts().istNichtterminal(), ""+reg);
    }
  }

  @ParameterizedTest
  @ValueSource(
      strings = { "bbbc", "bbbbc", "bbbbb", "bbbbbbb", "bbbbbc"})
  public void testOK(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(
      strings = { "", "b", "bb", "bbb", "bbbb", "c", "bc", "bbc", "a"})
  public void testNicht(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte nicht ableitbar sein in\n");
  }
}
