package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;
import zustand.Zustand;

public class KFGOhneKetteWiederholungTest {
  private KontextfreieGrammatik sut;
  // Grammatik hier eingeben
  private String gram = """
      N: Start A B
      T: a b
      S: Start
      Start -> aABb | aaa | bBAa | ab | ba          
      A -> aaa | bBAa | ab | ba | aABb           
      B -> ab | ba | aaa | bBAa | aABb
      """;

  @BeforeEach
  public void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    this.sut.stringAlsGrammatik(gram);
  }
  
  @Test
  public void testStruktur() {
    for(KontextfreieRegel reg: this.sut.getRegeln()) {
      Assertions.assertFalse(reg.getRechts().laenge() == 1 
          && reg.getRechts().istNichtterminal(), "nicht erlaubt: " + reg);
    }
  }

  @ParameterizedTest
  @ValueSource(
      strings = {"aaa","aababb","aabbab","ab","abaabb","ababab","ba"
          ,"bababa","babbaa","bbaaba","bbabaa"})
  public void testOK(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(
      strings = {"","a","aa","aaaa","aaaaa","aaaaaa","aaaaab","aaaab"
          ,"aaaaba","aaaabb","aaab","aaaba","aaabaa","aaabab","aaabb"
          ,"aaabba","aaabbb","aab","aaba","aabaa","aabaaa","aabaab"
          ,"aabab","aababa","aabb","aabba","aabbaa","aabbb","aabbba"
          ,"aabbbb","aba","abaa","abaaa","abaaaa","abaaab","abaab"
          ,"abaaba","abab","ababa","ababaa","ababb","ababba","ababbb"
          ,"abb","abba","abbaa","abbaaa","abbaab","abbab","abbaba"
          ,"abbabb","abbb","abbba","abbbaa","abbbab","abbbb","abbbba"
          ,"abbbbb","b","baa","baaa","baaaa","baaaaa","baaaab","baaab"
          ,"baaaba","baaabb","baab","baaba","baabaa","baabab","baabb"
          ,"baabba","baabbb","bab","baba","babaa","babaaa","babaab"
          ,"babab","bababb","babb","babba","babbab","babbb","babbba"
          ,"babbbb","bb","bba","bbaa","bbaaa","bbaaaa","bbaaab","bbaab"
          ,"bbaabb","bbab","bbaba","bbabab","bbabb","bbabba","bbabbb"
          ,"bbb","bbba","bbbaa","bbbaaa","bbbaab","bbbab","bbbaba"
          ,"bbbabb","bbbb","bbbba","bbbbaa","bbbbab","bbbbb","bbbbba"
          ,"bbbbbb"})
  public void testNicht(String wort) {
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\""
        + " sollte nicht ableitbar sein in\n");
  }
}
