package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class KFGWiederholung_L1_L2_Test {
  private KontextfreieGrammatik sut;
  
  // hier Grammatiken eintragen
  String l1 = """
      T: a b c
      N: Start A B C
      S: Start
      Start -> aAbbBC            
      A -> aA | /eps         
      B-> bB | /eps        
      C -> ccc | cc | c | /eps
      """;
  
  String l2 = """
      T: a b c
      N: Start A B C X
      S: Start
      Start -> aStartc | aBcC      
      B -> bB | bb     
      C -> cC | c
      Start -> AbbXccC       
      X -> bXc |/eps  
      A -> aA | a
      """;

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new KontextfreieGrammatik();
    
  }

  @ParameterizedTest
  @ValueSource(strings = {"abb", "aabb", "abbb", "abbc", "abbcc", "abbccc"})
  void testOKL1(String wort) {
    this.sut.stringAlsGrammatik(l1);
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\"" 
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(strings = {"", "a", "ab", "bb", "aab", "aaabbcccc", "c"})
  void testNichtL1(String wort) {
    this.sut.stringAlsGrammatik(l1);
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\"" 
        + " sollte nicht ableitbar sein in\n");
  }
  
  @ParameterizedTest
  @ValueSource(strings = {"abbccc", "aabbccc", "aaaabbccccc"
      , "abbcccccc", "aabbbbccccc", "abbcc", "aaabbccc"})
  void testOKL2(String wort) {
    this.sut.stringAlsGrammatik(l2);
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertTrue(erg, "\"" + util.Util.text(wort) + "\"" 
        + " sollte ableitbar sein in\n");
  }

  @ParameterizedTest
  @ValueSource(strings = {"", "ab", "bb", "c", "abb", "abbc", "aabbcc"
      , "aaabbbccc", "aaaaaabbbbbbcccccc"})
  void testNichtL2(String wort) {
    this.sut.stringAlsGrammatik(l2);
    boolean erg = this.sut.ableitbar(wort);
    Assertions.assertFalse(erg, "\"" + util.Util.text(wort) + "\"" 
        + " sollte nicht ableitbar sein in\n");
  }
}
