package test.kontextfreieGrammatik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class KFGalleAbleitbarenWorte {

  @BeforeEach
  public void setup() {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
  }

  @Test
  public void testAlleAbleitbarenWorte() {
    String grammatik = // nur Beispiel zur Fuellung der Terminale
        """
        %ignorespaces
        N: Start A B
        T: a b c
        S: Start
        Start -> A | /eps       
        A-> aA | bA | cA | a | b | c         
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertEquals(121,g.alleAbleitbarenWortBisZurLaenge(4).size()
        ,g.alleAbleitbarenWortBisZurLaenge(4).toString());
  }
  
  @Test
  public void testAlleAbleitbarenWorteNurEinWort() {
    String grammatik = // nur Beispiel zur Fuellung der Terminale
        """
        %ignorespaces
        N: Start A B
        T: a b c
        S: Start
        Start -> A | /eps       
        A-> aA | bA | cA        
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertEquals(1,g.alleAbleitbarenWortBisZurLaenge(4).size()
        ,g.alleAbleitbarenWortBisZurLaenge(4).toString());
  }
  
  @Test
  public void testAlleAbleitbarenWorteTeilmenge() {
    String grammatik = // nur Beispiel zur Fuellung der Terminale
        """
        %ignorespaces
        N: Start A B
        T: a b c
        S: Start
        Start -> A | /eps       
        A-> aA | bA  | cB | a | b         
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertEquals(31,g.alleAbleitbarenWortBisZurLaenge(4).size()
        ,g.alleAbleitbarenWortBisZurLaenge(4).toString());
  }
}
