package test.kontextfreieGrammatik;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;
import grammatik.OptimierteGrammatik;

public class OptimierungsTest {

  private static KontextfreieGrammatik prototyp;
  
  private static KontextfreieGrammatik optimiert;
  
  public static void init(String datei) {
    Nichtterminal.reset();
    Terminal.reset();
    prototyp = new KontextfreieGrammatik();
    
    // hier optimierte Version erzeugen
    optimiert = new OptimierteGrammatik();
    
    prototyp.dateiEinlesen(datei);
    prototyp.setIgnoriereLeerzeichen(true);
    optimiert.dateiEinlesen(datei);
    optimiert.setIgnoriereLeerzeichen(true);
  }
  
  public static void main(String[] args) {
    if (checkBasics()) {
      // um Zeiten bei der Initialisierung nicht zu beachten
      // wird jede Analyse zunaechst ohne und dann mit Ergebnis
      //durchgefuehrt
      testOhneEpsilon(false);
      testOhneEpsilon(true);
      testOhneKettenregeln(false);
      testOhneKettenregeln(true);
      testBeispielgrammatik(false);
      testBeispielgrammatik(true);
    }
  }
  
  public static boolean checkBasics() {
    init("beispiele" + util.Util.FS + "kontextfreiegrammatiken" + util.Util.FS + "KFGTestZumUmformen.kfg");
    optimiert.inChomskyNormalform();
    for(KontextfreieRegel reg: optimiert.getRegeln()) {
      if (reg.getRechts().laenge() == 0
          && reg.getLinks() != optimiert.getStart()) {
        System.out.println("leeres Wort darf nur aus Startsymbol "
            + "ableitbar sein: " + reg);
        return false;
      }
      if (reg.getRechts().laenge() == 1 
          && reg.getRechts().istNichtterminal()) {
        System.out.println("Kettenregeln darf es nicht geben: " + reg);
        return false;
      }
      Wort w = reg.getRechts();
      if (w.laenge() > 2 
          || (w.laenge() == 1 && !w.terminal())
          || (w.laenge() == 2 && !w.ausNichtTerminalen())) {
        System.out.println("Regel nicht in Chomsky-Normalform: " + reg);
      }
      
    }
    return true;
  }
   
  public static void testBeispielgrammatik(boolean zeigen) {
    if(zeigen) {
      System.out.println("vollstaendiger Test:");
    }
    init("beispiele" + util.Util.FS + "kontextfreiegrammatiken" + util.Util.FS + "KFGTestChomsky.kfg");
    long start1 = System.currentTimeMillis();
    prototyp.inChomskyNormalform();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.inChomskyNormalform();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
  
  public static void testOhneEpsilon(boolean zeigen) {
    if(zeigen) {
      System.out.println("Ohne leeres Wort Test:");
    }
    init("beispiele" + util.Util.FS + "kontextfreiegrammatiken" + util.Util.FS + "KFGTestOhneEpsilon.kfg");
    long start1 = System.currentTimeMillis();
    prototyp.ohneLeeresWortRegeln();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.ohneLeeresWortRegeln();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
  
  public static void testOhneKettenregeln(boolean zeigen) {
    if(zeigen) {
      System.out.println("Ohne Kettenregeln Test:");
    }
    init("beispiele" + util.Util.FS + "kontextfreiegrammatiken" + util.Util.FS + "KFGTestOhneKetten.kfg");
    long start1 = System.currentTimeMillis();
    prototyp.entferneKettenregeln();
    long dauer1 = System.currentTimeMillis() - start1;
    long start2 = System.currentTimeMillis();
    optimiert.entferneKettenregeln();
    long dauer2 = System.currentTimeMillis() - start2;
    double ergebnis = 1 - (dauer2 *1.)/ dauer1;
    if(zeigen) {
      if (dauer2 - dauer1 <= 0) {
        System.out.println("Die Laufzeit wurde um " 
          + ergebnis  + " Prozent optimiert");
      } else {
        System.out.println("Die Laufzeit wurde um " 
          + (-ergebnis)  + " Prozent verringert");
      }
    }
  }
}
