package test.kontextfreieGrammatik;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import zustand.Zustand;

class WortTest {

  private Nichtterminal nt1;
  private Nichtterminal nt2;
  private Nichtterminal nt3;
  
  private Terminal t1;
  private Terminal t2;
  private Set<Nichtterminal> nts;
  
  @BeforeEach
  public void setUp() {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    nt1 = Nichtterminal.nichtterminal("A");
    nt2 = Nichtterminal.nichtterminal("Befehl");
    nt3 = Nichtterminal.nichtterminal("C");
    t1 = Terminal.terminal("a");
    t2 = Terminal.terminal("b");
    this.nts = new HashSet<>();
    this.nts.add(nt1);
    this.nts.add(nt2);
  }
  
  @AfterEach
  public void tearDown() {
    Zeichen.reset();
    //Nichtterminal.reset();
    //Terminal.reset();
  }
  
  
  @Test
  void testWortBasis() {
    Wort w = new Wort();
    Assertions.assertEquals(0, w.laenge());
    Assertions.assertTrue(w.terminal());
    Assertions.assertTrue(w.positionenVon(t1).isEmpty());
    try {
      w.ersetzeAnPositionMit(0, new Wort());
      Assertions.fail();
    }catch(IllegalStateException e){}
    try {
      w.ersetzenVonMitNummer(nt1, new Wort(), 1);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertFalse(w.istNichtterminal());
    try {
      w.alsNichtterminal();
      Assertions.fail();
    }catch(IllegalStateException e){}
    try {
      w.vonBis(0, 1);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertTrue(w.bestehtAus(nts));
  }

  @Test
  void testWortBasis2() {
    Wort w = new Wort(nt2);
    Assertions.assertEquals(1, w.laenge());
    Assertions.assertFalse(w.terminal());
    Assertions.assertTrue(w.positionenVon(t1).isEmpty());
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(1, w.positionenVon(nt2).size());
    try {
      w.ersetzeAnPositionMit(1, new Wort());
      Assertions.fail();
    }catch(IllegalStateException e){}
    try {
      w.ersetzenVonMitNummer(nt1, new Wort(), 1);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertTrue(w.istNichtterminal());
    Assertions.assertEquals(nt2, w.alsNichtterminal());
    try {
      w.vonBis(0, 2);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertTrue(w.bestehtAus(nts));
  }
  
  @Test
  void testWortBasis3() {
    Wort w = new Wort(t2);
    Assertions.assertEquals(1, w.laenge());
    Assertions.assertTrue(w.terminal());
    Assertions.assertTrue(w.positionenVon(t1).isEmpty());
    Assertions.assertEquals(0, w.positionenVon(t2).get(0));
    Assertions.assertEquals(1, w.positionenVon(t2).size());
    Assertions.assertEquals(0, w.positionenVon(t1).size());
    try {
      w.ersetzeAnPositionMit(1, new Wort());
      Assertions.fail();
    }catch(IllegalStateException e){}
    try {
      w.ersetzenVonMitNummer(nt1, new Wort(), 1);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertFalse(w.istNichtterminal());
    try {
      w.vonBis(0, 2);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertFalse(w.bestehtAus(nts));
  }
  
  @Test
  void testWortBasis4() {
    Wort w = new Wort(nt2, t2);
    Assertions.assertEquals(2, w.laenge());
    Assertions.assertFalse(w.terminal());
    Assertions.assertTrue(w.positionenVon(t1).isEmpty());
    Assertions.assertEquals(1, w.positionenVon(t2).get(0));
    Assertions.assertEquals(1, w.positionenVon(t2).size());
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(1, w.positionenVon(nt2).size());
    Assertions.assertEquals(0, w.positionenVon(t1).size());
    try {
      w.ersetzeAnPositionMit(2, new Wort());
      Assertions.fail();
    }catch(IllegalStateException e){}
    try {
      w.ersetzenVonMitNummer(nt1, new Wort(), 1);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertFalse(w.istNichtterminal());
    try {
      w.vonBis(0, 3);
      Assertions.fail();
    }catch(IllegalStateException e){}
    Assertions.assertFalse(w.bestehtAus(nts));
  }
  
  @Test
  void testWortBasis5() {
    Wort w = new Wort(nt2, t2);
    w.anfuegen(nt1);
    Assertions.assertEquals(3, w.laenge());
    Assertions.assertFalse(w.terminal());
    Assertions.assertEquals(nt2, w.at(0));
    Assertions.assertEquals(t2, w.at(1));
    Assertions.assertEquals(nt1, w.at(2));
    w.anfuegen(nt2);
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(3, w.positionenVon(nt2).get(1));
    Assertions.assertEquals(1, w.positionenVon(t2).size());
    w.ersetzeAnPositionMit(1, new Wort(nt2));
    // w = nt2 nt2 nt1 nt2
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(1, w.positionenVon(nt2).get(1));
    Assertions.assertEquals(3, w.positionenVon(nt2).get(2));
    Assertions.assertEquals(0, w.positionenVon(t2).size());
    w.ersetzenVonMitNummer(nt2, new Wort(nt1), 2);
    // w = nt2 nt1 nt1 nt2
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(3, w.positionenVon(nt2).get(1));
    Assertions.assertEquals(2, w.positionenVon(nt2).size());
    Assertions.assertEquals(1, w.positionenVon(nt1).get(0));
    Assertions.assertEquals(2, w.positionenVon(nt1).get(1));
    Assertions.assertEquals(new Wort(nt2), w.vonBis(0, 1));
    Assertions.assertEquals(new Wort(nt1, nt1), w.vonBis(1, 3));
    Assertions.assertEquals(new Wort(nt1, nt1, nt2), w.vonBis(1, 4));
    
    int count = 0;
    for (Iterator<Zeichen> iterator = w.iterator(); iterator
        .hasNext();) {
      iterator.next();
      count++;
    }
    Assertions.assertEquals(4, count);
    
    w.ersetzeAnPositionMit(3, new Wort(nt3));
    // w = nt2 nt1 nt1 nt3
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(2, w.positionenVon(nt1).get(1));
    Assertions.assertEquals(3, w.positionenVon(nt3).get(0));
    Assertions.assertEquals(0, w.positionenVon(t2).size());
    Assertions.assertFalse(w.bestehtAus(nts));
    
    w.ersetzenVonMitNummer(nt3, new Wort(nt1), 1);
    // w = nt2 nt1 nt1 nt1
    Assertions.assertEquals(0, w.positionenVon(nt2).get(0));
    Assertions.assertEquals(3, w.positionenVon(nt1).get(2));
    Assertions.assertEquals(0, w.positionenVon(nt3).size());
    Assertions.assertEquals(1, w.positionenVon(nt1).get(0));
    Assertions.assertTrue(w.bestehtAus(nts));
    
  }
  
}
