package test.semantik;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import semantik.Interpretation;
import semantik.SemantikBasisspracheDateiSingle;
import semantik.SemantikProgramm;
import zustand.Zustand;

public class SemantikProgrammDateiSingleTest {
  
  private SemantikProgramm sut;
  
  @BeforeAll
  public static void setUpOnce() throws Exception {
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    Zustand.reset();
  }

  @BeforeEach
  public void setUp() throws Exception {
    this.sut = new SemantikBasisspracheDateiSingle();
  }
  
  @Test
  public void testEinfacheZuweisung() {
    Interpretation ip = this.sut.ausfuehren("""
        x42 := 6;
        """);
    Assertions.assertEquals(6, ip.getInt("x42"));
  }
  
  @Test
  public void testZuweisungMitAusdruckUndSequenz() {
    Interpretation ip = this.sut.ausfuehren("""
        x42 := 6;
        x42 := x42 + 7;
        x42 := 18 + x42 - 10;
        """);
    Assertions.assertEquals(21, ip.getInt("x42"));
  }
  
  @Test
  public void testIfTrueMitAndOrKlammern() {
    Interpretation ip = this.sut.ausfuehren("""
        x42 := 6;
        u := 11;
        if(x42 == 6 and u<42 and (x42>0 or 2 == 1 or (false))) {
          u := 12;
        } else {
          u := 13;
        }
        """);
    Assertions.assertEquals(6, ip.getInt("x42"));
    Assertions.assertEquals(12, ip.getInt("u"));
  }
  
  @Test
  public void testIfFalseUndNotMitOr() {
    Interpretation ip = this.sut.ausfuehren("""
        x42 := 6;
        u := 11;
        if((not(x42 == 6) or ((true) and 42 == 40 + 1))) {
          u := 12;
        } else {
          u := 13;
        }
        """);
    Assertions.assertEquals(6, ip.getInt("x42"));
    Assertions.assertEquals(13, ip.getInt("u"));
  }
  
  @Test
  public void testSchleife() {
    Interpretation ip = this.sut.ausfuehren("""
        x := 6;
        u := 0;
        y := 0;
        z := 0;
        while (not(z == x)) {
          if (u == 1) {
            y := y + z;
          } else {
            y := y;
          }
          u := 1 - u;
          z := z + 1;
        }
        """);
    Assertions.assertEquals(0, ip.getInt("u"));
    Assertions.assertEquals(6, ip.getInt("x"));
    Assertions.assertEquals(9, ip.getInt("y"));
    Assertions.assertEquals(6, ip.getInt("z"));
  }
}
