package test.turingMaschine;

import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TMABgeordnetTest {

  private TuringMaschine sut;
  
  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" + util.Util.FS + "TMABgeordnet.tm");
  }
  
  @ParameterizedTest
  @CsvSource({",", "a,a", "b,b", "ab,ab", "ba,ab", "bb,bb"
    , "aa,aa", "aba,aab", "baa,aab", "bab,abb"
    , "abababab,aaaabbbb", "babababa,aaaabbbb"})
  void testOK(String eingabe, String erwartet) {
    if (eingabe == null) {
      eingabe = "";
    }
    if (erwartet == null) {
      erwartet = "";
    }
    Wort erg = this.sut.berechnen(eingabe);
    Assertions.assertEquals(new Wort(erwartet), erg
        ,"Fuer Eingabe " + util.Util.text(eingabe)
         + " erwartetes Erebnis: " + util.Util.text(erwartet)
         + " berechnetes Ergebnis: " + util.Util.text(erg));
  }

}
