package test.turingMaschine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TMKlausurAnalyse2PraktikumsaufgabeTest {
//TMKlausurAnalyse2Praktikumsaufgabe
  private TuringMaschine sut;

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" + util.Util.FS + "TMKlausurAnalyse2Praktikumsaufgabe.tm");
  }

  @ParameterizedTest
  @ValueSource(strings = {"", "abc", "b", "abaa", "bbaa", "ccc"})
  void testOK(String eingabe) {
    String erg = "";
    for(int i = 0; i < eingabe.length(); i++) {
      erg += "b";
    }
    Wort berechnet = sut.berechnen(eingabe);
    Assertions.assertEquals(new Wort(erg), berechnet
        , "Fuer Das Wort " + util.Util.text(eingabe) 
        + " sollte das Ergebnis " +  util.Util.text(erg)
        + " werden, es wurde aber berechnet: util.Util.text(berechnet)");
  }
}