package test.turingMaschine;

import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TMPlus1Test {

  private TuringMaschine sut;
  
  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" + util.Util.FS + "TMPlus1.tm");
  }
  
  @ParameterizedTest
  @CsvSource({"0,1", "1,10", "10,11", "11,100", "1001,1010", "11111,100000"})
  void testOK(String eingabe, String erwartet) {
    if (eingabe == null) {
      eingabe = "";
    }
    if (erwartet == null) {
      erwartet = "";
    }
    Wort erg = this.sut.berechnen(eingabe);
    Assertions.assertEquals(new Wort(erwartet), erg
        ,"Fuer Eingabe " + util.Util.text(eingabe)
         + " erwartetes Erebnis: " + util.Util.text(erwartet)
         + " berechnetes Ergebnis: " + util.Util.text(erg));
  }
}
