package test.turingMaschine;

import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TMSwapTest {

  private TuringMaschine sut;
  
  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" + util.Util.FS + "TMSwap.tm");
  }

  @Test
  void test1() {
    Wort[] erg = this.sut.berechnen(2, 2,"IIIIII", "III");
    Assertions.assertEquals("III", erg[0].toString());
    Assertions.assertEquals("IIIIII", erg[1].toString());
  }
  
  @Test
  void test2() {
    Wort[] erg = this.sut.berechnen(2, 2,"IIII", "III");
    Assertions.assertEquals("III", erg[0].toString());
    Assertions.assertEquals("IIII", erg[1].toString());
  }
  
  @Test
  void test3() {
    Wort[] erg = this.sut.berechnen(2, 2,"II", "III");
    Assertions.assertEquals("III", erg[0].toString());
    Assertions.assertEquals("II", erg[1].toString());
  }
  
  @Test
  void test4() {
    Wort[] erg = this.sut.berechnen(2, 2,"III", "II");
    Assertions.assertEquals("II", erg[0].toString());
    Assertions.assertEquals("III", erg[1].toString());
  }
  
  @Test
  void test5() {
    Wort[] erg = this.sut.berechnen(2, 2,"III", "III");
    Assertions.assertEquals("III", erg[0].toString());
    Assertions.assertEquals("III", erg[1].toString());
  }
  
  @Test
  void test6() {
    Wort[] erg = this.sut.berechnen(2, 2,"I", "");
    Assertions.assertEquals("", erg[0].toString());
    Assertions.assertEquals("I", erg[1].toString());
  }
  
  @Test
  void test7() {
    Wort[] erg = this.sut.berechnen(2, 2,"", "I");
    Assertions.assertEquals("I", erg[0].toString());
    Assertions.assertEquals("", erg[1].toString());
  }
  
  @Test
  void test8() {
    Wort[] erg = this.sut.berechnen(2, 2,"", "");
    Assertions.assertEquals("", erg[0].toString());
    Assertions.assertEquals("", erg[1].toString());
  }
  
  @Test
  void test9() {
    Wort[] erg = this.sut.berechnen(2, 2,"IIII", "I");
    Assertions.assertEquals("I", erg[0].toString());
    Assertions.assertEquals("IIII", erg[1].toString());
  }

}
