package test.turingMaschine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

//benoetigt /theoriesammlung/beispiele/turingmaschinen/TMa_nb_nc_n.tm
public class TMa_nb_nTest {
  private TuringMaschine sut;

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS 
        + "turingmaschinen" + util.Util.FS + "TMa_nb_n.tm");
  }

  @ParameterizedTest
  @ValueSource(strings = {"ab", "aabb", "aaaaaabbbbbb"})
  void testOK(String wort) {
    boolean erg = this.sut.akzeptieren(wort);
    Assertions.assertTrue(erg, "Das Wort " + util.Util.text(wort) 
    + " sollte akzeptiert werden, wurde es aber nicht");
  }

  @ParameterizedTest
  @ValueSource(strings = {"", "a", "b", "ba", "aa", "aba", "abb", "aab"
      , "aaabb", "baabb"})
  void testNicht(String wort) {
    boolean erg = this.sut.akzeptieren(wort);
    Assertions.assertFalse(erg, "Das Wort " + util.Util.text(wort) 
    + " sollte nicht akzeptiert werden, wurde es aber");
  }
}