package test.turingMaschine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TMa_nplus2b_nTest {
  private TuringMaschine sut;

  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" 
        + util.Util.FS + "TMa_nplus2b_n.tm");
  }

  @ParameterizedTest
  @ValueSource(strings = {"aa", "aaab", "aaaaaabbbb"})
  void testOK(String eingabe) {
    Assertions.assertTrue(this.sut.akzeptieren(eingabe)
        , "Das Wort " + util.Util.text(eingabe) 
    + " sollte akzeptiert werden, wurde es aber nicht");
  }
  
  @ParameterizedTest
  @ValueSource(strings = {"", "a", "aab", "aaa", "aaabb", "bbbb"})
  void testNOK(String eingabe) {
    Assertions.assertFalse(this.sut.akzeptieren(eingabe)
        , "Das Wort " + util.Util.text(eingabe) 
    + " sollte nicht akzeptiert werden, wurde es aber"
    );
  }
}