package test.turingMaschine;

import org.junit.jupiter.api.Assertions;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class TmBeispiel6_3_4Test {

  private TuringMaschine sut;
  
  @BeforeEach
  void setUp() throws Exception {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    this.sut = new TuringMaschine();
    this.sut.dateiEinlesen("beispiele" + util.Util.FS + "turingmaschinen" + util.Util.FS + "TmBeispiel6_3_4ww.tm");
  }
  
  @ParameterizedTest
  @ValueSource(strings = {"ata", "btb", "t"
      , "abbatabba"})
  void testOK(String wort) {
    this.sut.berechnen(wort);
    Assertions.assertTrue(this.sut.isHalt(), "Das Wort " + util.Util.text(wort) 
      + " sollte die TM zum Halten bringen, tut sie aber nicht");
  }

  @ParameterizedTest
  @ValueSource(strings = {"bbb", "atb", "abbtabbb", "abbbtabb"
      , "a"})
  void testNicht(String wort) {
    try {
      this.sut.berechnen(wort);
      Assertions.fail("Beim Wort " + wort 
          + " sollte die TM abbrechen, tut sie aber nicht");
    } catch(IllegalStateException e) {
    }
  }
}
