package test.zustand;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import zustand.Zustand;

public class ZustandTest {
  
  @BeforeEach
  public void setUp() {
    Zustand.reset();
  }

  @Test
  public void testNeuerZustand() {
    Zustand z = Zustand.zustand("blubb");
    Assertions.assertEquals("blubb", z.getName());
  }
  
  @Test
  public void testGleicherZustand() {
    Zustand z = Zustand.zustand("bl");
    Zustand z2 = Zustand.zustand("bl");
    Assertions.assertSame(z, z2);
  }
  
  @Test
  public void testNichtGleicherZustand() {
    Zustand z = Zustand.zustand("bl");
    Zustand z2 = Zustand.zustand("bm");
    Assertions.assertNotEquals(z, z2);
  }
  
  @Test
  public void testReset() {
    Zustand.zustand("bl");
    Zustand.zustand("bm");
    Zustand.reset();
    Assertions.assertFalse(Zustand.istZustand("bl"));
    Assertions.assertFalse(Zustand.istZustand("bm"));
  }
  
  @Test
  public void testNeuGenerierterZustand() {
    for(int i = 0; i < 100; i++) {
      Zustand.neu();
    }
    Zustand tmp = Zustand.neu();
    for(String n1: tmp) {  // etwas schraeg ueber alle Zustandsnamen iterieren
      int gleich = 0;
      for(String n2: tmp) {
        if(n1.equals(n2)) {
          gleich ++;
        }
      }
      Assertions.assertEquals(1, gleich);
    }    
  }

}
