package turingMaschine;

import java.util.Objects;

import alphabet.Wort;
import alphabet.Zeichen;
import zustand.Zustand;

public class Konfiguration {
  private Zustand zustand;
  private Wort links;
  private Zeichen kopf;
  private Wort rechts;
  private TMModusStart mod;
  
  public Konfiguration(Zustand zustand, Wort links, Zeichen kopf,
      Wort rechts) {
    this(zustand, links, kopf, rechts, TMModusStart.HINTERDEMENDE);
  }
  
  public Konfiguration(Zustand zustand, Wort links, Zeichen kopf,
      Wort rechts, TMModusStart mod) {
    super();
    this.mod = mod;
    this.zustand = zustand;
    this.links = links;
    this.kopf = kopf;
    this.rechts = rechts;
  }
  
  @Override
  public String toString() {
    return "(" + this.zustand + ", " + this.links + "\u001b[4m" 
        + this.kopf + "\u001b[0m" 
        + this.rechts +")";
  }

  public Zustand getZustand() {
    return zustand;
  }

  public void setZustand(Zustand zustand) {
    this.zustand = zustand;
  }

  public Wort getLinks() {
    return links;
  }

  public void setLinks(Wort links) {
    this.links = links;
  }

  public Zeichen getKopf() {
    return kopf;
  }

  public void setKopf(Zeichen kopf) {
    this.kopf = kopf;
  }

  public Wort getRechts() {
    return rechts;
  }

  public void setRechts(Wort rechts) {
    this.rechts = rechts;
  }

  @Override
  public int hashCode() {
    return Objects.hash(kopf, links, rechts, zustand);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Konfiguration other = (Konfiguration) obj;
    return Objects.equals(kopf, other.kopf)
        && Objects.equals(links, other.links)
        && Objects.equals(rechts, other.rechts)
        && Objects.equals(zustand, other.zustand);
  }
  
  @Override
  public Konfiguration clone() {
    return new Konfiguration(this.zustand.clone(), this.links.clone()
        , this.kopf.clone(), this.rechts.clone(), this.mod);
  }
  
}
