package util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class Paar<Links extends Serializable & Cloneable
,Rechts extends Serializable & Cloneable> implements Serializable, Cloneable {
  private static final long serialVersionUID = 1L;
  public Links links;
  public Rechts rechts;
  
  public Paar() {}
  
  public Paar(Links links, Rechts rechts) {
    this.links = links;
    this.rechts = rechts;
  }

  public Links getLinks() {
    return links;
  }

  public void setLinks(Links links) {
    this.links = links;
  }

  public Rechts getRechts() {
    return rechts;
  }

  public void setRechts(Rechts rechts) {
    this.rechts = rechts;
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, rechts);
  }

  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Paar<Links, Rechts> other = (Paar<Links, Rechts>) obj;
    return Objects.equals(links, other.links)
        && Objects.equals(rechts, other.rechts);
  }

  @Override
  public String toString() {
    return "Paar [links=" + links + ", rechts=" + rechts + "]";
  }
  
  // Anscheinend ist die Kombination von Generics und Clone in Java
  // nicht einfach machbar :(
  // https://stackoverflow.com/questions/53250170/how-to-properly-implement-the-call-to-clone-in-a-generic-class-java
  
  @Override
  @SuppressWarnings("unchecked")
  public Paar<Links, Rechts> clone() {
      Paar<Links, Rechts> ergebnis = new Paar<>();
      Method clonel = null;
      Method cloner = null;
      try {
          clonel = this.links.getClass().getMethod("clone");
          cloner = this.rechts.getClass().getMethod("clone");
          Object[] args = new Object[0];
          ergebnis.links = (Links)clonel.invoke(this.links, args);
          ergebnis.rechts = (Rechts)cloner.invoke(this.rechts, args);
          return ergebnis;
      } catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException
              | InvocationTargetException e) {
          throw new RuntimeException(e);
      }

  }

}
