package zustand;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class Zustand implements Iterable<String>, Cloneable
    , Serializable{

  private static final long serialVersionUID = 1L;
  private String name;

  private static Map<String, Zustand> alleZustand = new HashMap<>();
  private static int count = 1;

  private Zustand(String name) {   
    this.name = name;
    alleZustand.put(name, this);
  }
    
  /** Menge der Zustaende werden zurueckgesetzt und damit
   * geloescht.
   */
  public static void reset() {
    alleZustand = new HashMap<>();
  }
   
  /** Es wird der zum uebergebenen String zugehoerige Zustand
   * zurueckgegeben. Existiert der Zustand noch nicht, wird er
   * borher erzeugt.
   * @param z Name des zu suchenden Zustand
   * @return das zu z gehoerende Zustand
   */
  public static Zustand zustand(String z) {
    Zustand erg = alleZustand.get(z);
    if (erg == null) {
      erg = new Zustand(z);
      alleZustand.put(z, erg);
    }
    return erg;
  }
  
  /** Prueft ob es zum Namen einen Zustand gibt.
   * 
   * @param z zu überpruefender String
   * @return existiert Zusdtand mit Namen z?
   */
  public static boolean istZustand(String z) {
    return alleZustand.get(z) != null;
  }

  /** Berechnet einen neuen Zustand, den es bisher nicht gibt.
   * 
   * @return garantiert neuer Zustand
   */
  public static Zustand neu() {
    boolean neu = false;
    String name = null;
    while(!neu) {
      name = "" + count;
      while(name.length() < 4) {
        name = "0" + name;
      }
      count++;
      if(alleZustand.get("z" + name) == null) {
        neu = true;
      }
    }
    return zustand("z" + name);
        
  }
  
  public String getZustand() {
    return name;
  }

  public void setZustand(String zeichen) {
    this.name = zeichen;
  }

  @Override
  public String toString() {
    return this.name;
  }

   /** Ermoeglicht das Durchlaufen der Namen aller vergebenen 
    *  Zustaende. 
   */
  @Override
  public Iterator<String> iterator() {
    return alleZustand.keySet().iterator();
  }
  
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public int hashCode() {
    return Objects.hash(name);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Zustand other = (Zustand) obj;
    return Objects.equals(name, other.name);
  }

  @Override
  public Zustand clone() {
    return this;
  }
}
