package main;

import persist.VerwaltungInterface;

public class Dialog {

    private VerwaltungInterface vw;

    public Dialog() {
        //this.vw = new  // hier muss ein Objekt Ihrer Implementierung entstehen
        //this.laden();
    }

    public void dialog() {
        int eingabe = -1;
        while (eingabe != 0) {
            System.out.println("\nWas wollen Sie?\n"
                    + "(0) Programm beenden\n"
                    + "(1) neuen Studi hinzufuegen\n"
                    + "(2) alle Studis zeigen\n"
                    + "(3) Namen eines Studi aendern\n"
                    + "(4) Studis eines Fachs zeigen\n"
                    + "(5) Studi loeschen\n"
                    + "(6) Daten speichern\n"
                    + "(7) Daten laden");
            eingabe = Eingabe.leseInt();
            switch (eingabe) {
                case 1:
                    this.studiHinzu();
                    break;
                case 2:
                    this.alleStudis();
                    break;
                case 3:
                    this.studinamenAendern();
                    break;
                case 4:
                    this.studisEinesFachs();
                    break;
                case 5:
                    this.studiLoeschen();
                    break;    
                case 6:
                    this.speichern();
                    break;
                case 7:
                    this.laden();
                    break;
            }
        }
    }

    public void laden() {
        this.vw.laden();
    }

    public void speichern() {
        this.vw.speichern();
    }

    public void studinamenAendern() {
        System.out.print("Matrikelnummer:");
        int mat = Eingabe.leseInt();
        System.out.print("neuer Name: ");
        if (this.vw.studiAendern(mat, Eingabe.leseString())) {
            System.out.println("erfolgreich geaendert");
        } else {
            System.out.println("nicht geaendert");
        }
    }

    public void alleStudis() {
        for (String s : this.vw.alleStudis()) {
            System.out.println(s);
        }
    }

    public void studiHinzu() {
        System.out.print("Name: ");
        String name = Eingabe.leseString();
        System.out.print("Matrikelnummer: ");
        int matnr = Eingabe.leseInt();
        System.out.append("Fach: ");
        String fach = Eingabe.leseString();
        if (this.vw.studiHinzu(matnr, name, fach)) {
            System.out.println("erfolgreich hinzugefuegt");
        } else {
            System.out.println("nicht hinzugefuegt");
        }
    }

    public void studisEinesFachs() {
        System.out.print("Fach: ");
        String fach = Eingabe.leseString();
        for (String s : this.vw.alleStudisDesFachs(fach)) {
            System.out.println(s);
        }
    }

    public void studiLoeschen() {
        System.out.print("Matrikelnummer: ");
        int matnr = Eingabe.leseInt();
        if (this.vw.studiLoeschen(matnr)) {
            System.out.println("erfolgreich geloescht");
        } else {
            System.out.println("nicht geloescht");
        }
    }
}
