package main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.github.stefanbirkner.systemlambda.SystemLambda;

public class SystemTest {

    private Dialog dialog;

    private List<String[]> beispiele ;

    @BeforeEach
    public void setUp() throws Exception{
        this.dialog = new Dialog();
        this.beispiele = Arrays.asList(
                new String[][]{
              {"Ute", "42", "TI"}
            , {"Ulf", "43", "TI"}
            , {"Sergej", "44", "TI"}
            , {"Ahmad", "45", "MI"}
            , {"Jan", "46", "MI"}
            , {"Jim", "47", "WI"}
            , {"Jana", "48", "WI"}
            , {"Esra", "49", "TI"}
        });
        this.tearDown();
    }

    // SystemLambda.withTextFromSystemIn(daten): daten steht
    //     fuer Eingaben in der Konsole
    // SystemLambda.tapSystemOutNormalized: enthaltene Methode
    //     studiHinzu wird ausgefuehrt und der dabei auf der Konsole
    //     ausgegebene Text wird zurueckgegeben
    private String studiHinzu(String... daten) throws Exception {
        return SystemLambda.tapSystemOutNormalized(() -> {
          SystemLambda.withTextFromSystemIn(daten)
          .execute(() -> {
            this.dialog.studiHinzu();
          });
        });
    }

    private String alleStudis() throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        this.dialog.alleStudis();
      });
    }

    private String studiNameAendern(int mat, String name) throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        SystemLambda.withTextFromSystemIn(new String[]{mat + "", name})
        .execute(() -> {
          this.dialog.studinamenAendern();
        });
      });
    }

    private String studisDesFachs(String fach) throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        SystemLambda.withTextFromSystemIn(new String[]{fach})
        .execute(() -> {
          this.dialog.studisEinesFachs();
        });
      });
    }

    private String studiLoeschen(int mat) throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        SystemLambda.withTextFromSystemIn(new String[]{mat + ""})
        .execute(() -> {
          this.dialog.studiLoeschen();
        });
      });
    }

    // Da Speicherdatei nicht bekannt, alle Testdaten loeschen
    @AfterEach
    public void tearDown() throws Exception {
        for (int i = 42; i < 54; i++) {
            this.studiLoeschen(i);
        }
    }

    private void beispiele() throws Exception {
        for (String[] s : this.beispiele) {
            this.studiHinzu(s);
        }
    }

    private List<String[]> analyse(String log) {
        String[] stud = log.split("Studi\\{");
        //System.out.println(Arrays.asList(stud));
        List<String[]> ergebnisse = new ArrayList<>();
        for (String s : stud) {
            if (s.length() > 15) {
                String[] daten = s.split("(, )|(\\})");
                String[] tmp = {daten[0].substring(4)
                    , daten[1].substring(5), daten[2].substring(5)};
                ergebnisse.add(tmp);
            }
        }
        return ergebnisse;
    }

    private String vergleichen(List<String[]> daten, List<String[]> beispiele) {
        if (daten.size() != beispiele.size()){
            return "Erwartet wurden " + beispiele.size() + " Ergebnisse "
                    + "gefunden wurden " + daten.size() + " Ergebnisse";
        }
        for(String[] d: beispiele){
            String[] gefunden = null;
            for(String[] v: daten){
                if(d[0].equals(v[1]) && d[1].equals(v[0]) && d[2].equals(v[2])){
                    gefunden = v;
                }
            }
            if (gefunden != null){
                daten.remove(gefunden);
            }
        }
        if(!daten.isEmpty()){
            return daten.size() + " falsche Datensaetze gefunden, "
                    + "u. a. " + Arrays.asList(daten.get(0));
        }
        return "";
    }
    
    @Test
    public void leererStart() throws Exception {
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals(0, daten.size()
            , "Tests laufen nur, wenn noch keine "
                + "Daten abgespeichert sind");
    }

    @Test
    public void beispieldatenKorrektEingespielt() throws Exception {
        this.beispiele();       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten,this.beispiele));
    }
    
    @Test
    public void ersterEintrag() throws Exception{
        String[] data = {"Sarah","42","TI"};
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(data);
        this.studiHinzu(data);      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
    
    @Test
    public void korrekterNeuerEintrag() throws Exception{
        this.beispiele();
        String[] data = {"Sarah","50","TI"};
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(data);
        erwartet.addAll(this.beispiele);
        this.studiHinzu(data);      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
    
    @Test
    public void doppelterNeuerEintrag() throws Exception{
        this.beispiele();
        String[] data = {"Sarah","44","TI"};
        this.studiHinzu(data);       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }
    
    @Test
    public void fachStudisOhneBisherigeEintraege() throws Exception{       
        List<String[]> daten = this.analyse(this.studisDesFachs("TI"));
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");         
    }
    
    @Test
    public void fachStudisOhneExistierendesFach1() throws Exception{       
        List<String[]> daten = this.analyse(this.studisDesFachs("GI"));
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");         
    }
    
    @Test
    public void existierendeFachstudisFinden() throws Exception{
        this.beispiele();      
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(this.beispiele.get(0));
        erwartet.add(this.beispiele.get(7));
        erwartet.add(this.beispiele.get(2));
        erwartet.add(this.beispiele.get(1));
        List<String[]> daten = this.analyse( this.studisDesFachs("TI"));
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
    
    @Test
    public void fachStudisOhneExistierendesFach2() throws Exception{
        this.beispiele();       
        List<String[]> daten = this.analyse(this.studisDesFachs("GI"));
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");         
    }
    
    @Test
    public void nameErfolgreichAendern() throws Exception{
        this.beispiele();
        this.studiNameAendern(49, "Elif");        
        List<String[]> daten = this.analyse(this.alleStudis());
        this.beispiele.get(7)[0] = "Elif";
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }

    @Test
    public void nameErfolglosAendern() throws Exception{
        this.beispiele();
        this.studiNameAendern(50, "Elif");       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }
    
    @Test
    public void nameErfolglosBeiLeeremDatenbestandAendern() throws Exception{
        this.studiNameAendern(50, "Elif");      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");        
    }

    @Test
    public void speichernUndLadenLeererDatenmenge() throws Exception{
        this.dialog.speichern();
        this.beispiele();
        this.dialog.laden();      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");
    }
    
    @Test
    public void ladenGespeicherterDaten() throws Exception{
        this.beispiele();
        this.dialog.speichern();
        this.tearDown();
        this.studiHinzu("X", "42", "MI");
        this.dialog.laden();       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));
    }
    
    @Test
    public void nutzungGespeicherterDaten() throws Exception{
        String[] data = {"Sarah","50","TI"};
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(data);
        erwartet.addAll(this.beispiele);
        this.studiHinzu(data);
        this.dialog.speichern();
        this.studiLoeschen(50);
        this.beispiele();
        this.studiLoeschen(42);
        this.dialog.laden();
        this.beispiele();       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
}
