package persist;

import java.util.Collection;

public interface VerwaltungInterface {

    /** Methode gibt eine Sammlung aller dem System bekannten
     * Studierenden zurueck.
     * @return Sammlung aller Studierenden
     */
    public Collection<String> alleStudis();
    
    /** Methode gibt eine Sammlung aller dem System bekannten
     * Studierenden des als Parameter uebergebenen Fachs zurueck.
     * @param fach Fach, dessen Studierende gesucht werden
     * @return Sammlung aller Studierenden des Fachs
     */
    public Collection<String> alleStudisDesFachs(String fach);

    /** Laedt alle gespeicherten Studierenden, bisher im System
     * befindliche Studierende gehen verloren.
     */
    public void laden();

    /** Speichert alle im System bekannten Studierenden. Aeltere
     * Datenbestaende werden üeberschrieben.
     */
    public void speichern();

    /** Aendert den Namen von Studierenden mit der Matrikelnummer
     * mat auf den uerbergebenen neuen Namen und gibt true zurueck.
     * Sollte es keinen Studierenden mit dieser Matrikelnummer geben,
     * ist das Ergebnis false.
     * @param mat Matrikelnummer des zu aendernden Studierenden
     * @param name neuer Name des Studierenden
     * @return wurde eine Aenderung durchgefuehrt?
     */
    public boolean studiAendern(int mat, String name);

    /** Fuegt Studi-Objekt mit den uebergebenen Daten
     * Matrikelnummer, Name sowie Fach hinzu und gibt true zurueck.
     * Sollte es vorher bereits einen Studierenden mit dieser 
     * Matrikelnummer geben, ist das Ergebnis false. 
     * @param mat Matrikelnummer des neuen Studierenden
     * @param name Name des neuen Studierenden
     * @param fach Fach des neuen Studierenden
     * @return 
     */
    public boolean studiHinzu(int mat, String name, String fach);
    
    /** Loescht einen Studierenden mit der uebergebenen
     * Matrikelnummer und gibt true zurueck. 
     * Sollte es keinen Studierenden mit dieser Matrikelnummer geben,
     * ist das Ergebnis false.
     * @param mat Matrikelnummer des zu loeschenden Studierenden
     * @return wurde eine Loeschung durchgefuehrt?
     */
    public boolean studiLoeschen(int mat);
    
}
