package main;

import java.lang.reflect.InvocationTargetException;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.scene.layout.BorderPane;
import javafx.scene.control.TextField;
import javafx.scene.text.Font;
import karte.Karte;

public class MainGui extends Application {

    private TextField eingabe = new TextField("");
    private Karte karte;
    
    @Override
    public void init() {
        Alle.alleKlassen().forEach(k ->{
            if(Alle.klasseImplementiertInterface(k, "karte.Karte")){
                try {
                    this.karte = (Karte) Class.forName(k).getDeclaredConstructor().newInstance();
                } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchMethodException | SecurityException ex) {
                    System.out.println("Implementierung von Karte " + k + " fehlt "
                            + "sichtbarer parameterloser Konstruktor");
                } 
            }
        });
        if (this.karte == null){
            System.out.println("Implementierung des Interfaces karte.Karte "
                    + "mit sichtbarem parameterlosen Konstruktor nicht gefunden");
            this.beenden();
        }
        System.out.println("initialisiert");
    }

    @Override
    public void start(Stage primaryStage) {
        primaryStage.setTitle("Eingabe (Ende mit \"ende\") ");

        BorderPane borderPane = new BorderPane();
        borderPane.setCenter(this.eingabe);

        this.eingabe.setOnAction(e -> {
            aktion(this.eingabe.getText());
            this.eingabe.setText("");
        });
        this.eingabe.setFont(new Font("Times", 20));

        primaryStage.setOnCloseRequest(e -> {
            this.beenden();
        });

        Scene scene = new Scene(borderPane);

        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.setWidth(375);
        primaryStage.setY(605);
        primaryStage.setX(0);
        primaryStage.show();
    }

    public void beenden() {
        System.out.println("ENDE");
        if(this.karte !=null) {
            this.karte.beenden();
        }
        System.exit(0);
    }

    public void aktion(String eingabe) {
        if (!eingabe.toLowerCase().equals("ende")) {
            System.out.println("Fenster: " + eingabe);
            this.karte.zeigeLand(eingabe);
        } else {
            this.beenden();
        }
    }

    public static void main(String[] args) {
        launch(args);
    }

}
