package main;

import classmodel.Alle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tabelle.FunktionaleAbhaengigkeitPruefer;
import tabelle.Tabelle;

public class Tabellenanalyse {

    private boolean geladen = false;
    private Tabelle tabelle = new Tabelle();
    private FunktionaleAbhaengigkeitPruefer pruefer;
    
    /** Methode sucht im Eclipse-Projekt nach einer Implementierung
     *  des vorgegebenen Interfaces und nutzt dabei Reflection.
     */
    public void sucheImplementierung() {
        String implementierung = null;
        for (String k : Alle.alleKlassen()) {
            if (Alle.klasseImplementiertInterface(k
                    , "tabelle.FunktionaleAbhaengigkeitPruefer")) {
                implementierung = k;
            }
        }
        if (implementierung == null) {
            throw new IllegalArgumentException("Keine Implementierung des"
                    + " Interfaces tabelle.FunktionaleAbhaengigkeitPruefer "
                    + "gefunden!");
        }
        Class<?> impl = Alle.moeglicheClassObjekteFuer(implementierung).get(0);
        try {
            this.pruefer = (FunktionaleAbhaengigkeitPruefer) impl.getConstructor().newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException("Implementierung hat keinen"
                    + " nutzbaren parameterlosen Konstruktor: " + e);
        }
    }

    public void dialog() {
        this.sucheImplementierung();
        int eingabe = -1;
        while (eingabe != 0) {
            System.out.println("\nWas wollen Sie?\n"
                    + "(0) Programm beenden\n"
                    + "(1) Tabelle laden");
            if (this.geladen) {
                System.out.println("(2) Tabelle zeigen\n"
                        + "(3) funktionale Abhaengigkeit pruefen\n"
                        + "(4) voll funktionale Abhaengigkeit pruefen\n"
                        + "(5) Schluessel pruefen\n"
                        + "(6) Schluesselkandidaten pruefen: ");
            }
            eingabe = Eingabe.leseInt();
            switch (eingabe) {
                case 1:
                    this.tabelleLaden();
                    break;
                case 2:
                    this.tabelleZeigen();
                    break;
                case 3:
                    this.funktionaleAbhaengigkeit();
                    break;
                case 4:
                    this.volleFunktionaleAbhaengigkeit();
                    break;
                case 5:
                    this.schluessel();
                    break;
                case 6:
                    this.schluesselkandidat();
                    break;
            }
        }
    }

    private void tabelleLaden() {
      String tabellenname = "";
        System.out.print("aus welcher Datei? ");
        try {
            tabellenname = Eingabe.leseString();
            this.tabelle.laden(tabellenname);
            this.geladen = true;
            System.out.println("Tabelle " + this.tabelle.getName() 
                    + " geladen.");
        } catch (Exception e) {
          try {
            this.tabelle.laden(tabellenname+".tabelle");
            this.geladen = true;
            System.out.println("Tabelle " + this.tabelle.getName() 
                    + " geladen.");
          } catch (Exception e2) {
              System.err.println("nicht geladen: " + e2.getMessage());
          }
        }
    }

    private void funktionaleAbhaengigkeit() {
        System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                + "der Spalten der definierenden Attribute ein (z. B.: 1 3 )");
        String[] von = this.attributauswahl();
        if (von != null) {
            System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                    + "der Spalten der potenziell abhaengigen Attribute "
                    + "ein (z. B.: 2 4 )");
            String[] abhaengig = this.attributauswahl();
            if (abhaengig != null) {
                System.out.println("Pruefe ob moeglich: " + Arrays.asList(von) 
                        + " --> " + Arrays.asList(abhaengig));
                System.out.println("Ergebnis: " 
                        + this.pruefer.kannFunktionalAbhaengigSein(this.tabelle
                                , von, abhaengig));
            }
        }
    }

    private String[] attributauswahl() {
        String[] spalten = this.tabelle.getSpaltenueberschriften();
        for (int i = 1; i <= spalten.length; i++) {
            System.out.print(i + ":" + spalten[i - 1] + "  ");
        }
        String eingabe = Eingabe.leseString().trim();
        if (eingabe.equals("")) {
          return new String[] {};
        }
        String[] werte = eingabe.split(" ");
        List<Integer> auswahl = new ArrayList<>();
        for (String w : werte) {
            try {
                int wert = Integer.parseInt(w);
                if (!auswahl.contains(wert) && wert <= spalten.length) {
                    auswahl.add(wert);
                }
            } catch (Exception e) {
                System.out.println("Eingabe " + w + " ignoriert");
            }
        }
        String[] ergebnis = new String[auswahl.size()];
        for (int i = 0; i < auswahl.size(); i++) {
            ergebnis[i] = spalten[auswahl.get(i) - 1];
        }
        return ergebnis;
    }

    private void volleFunktionaleAbhaengigkeit() {
        System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                + "der Spalten der definierenden Attribute ein (z. B.: 1 3 )");
        String[] von = this.attributauswahl();
        if (von != null) {
            System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                    + "der Spalten der potenziell voll abhaengigen Attribute "
                    + "ein (z. B.: 2 4 )");
            String[] abhaengig = this.attributauswahl();
            if (abhaengig != null) {
                System.out.println("Pruefe ob moeglich: " + Arrays.asList(von) 
                        + " -voll-> " + Arrays.asList(abhaengig));
                System.out.println("Ergebnis: " 
                        + this.pruefer.kannVollFunktionalAbhaengigSein(
                                this.tabelle, von, abhaengig));
            }
        }
    }

    private void schluessel() {
        System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                + "der Spalten des potenziellen Schluessels ein (z. B.: 1 3 )");
        String[] von = this.attributauswahl();
        if (von != null) {
            System.out.println("Pruefe ob moeglich: " + Arrays.asList(von) 
                    + " ist Schluessel von " + this.tabelle.getName());
            System.out.println("Ergebnis: " 
                    + this.pruefer.kannSchluesselSein(this.tabelle, von));
        }
    }

    private void tabelleZeigen() {
        this.tabelle.zeigen();
    }

    private void schluesselkandidat() {
        System.out.println("Geben Sie mit Leerzeichen getrennt die Nummern "
                + "der Spalten des potenziellen Schluesselkandidaten ein (z. B.: 1 3 )");
        String[] von = this.attributauswahl();
        if (von != null) {
            System.out.println("Pruefe ob moeglich: " + Arrays.asList(von) 
                    + " ist Schluesselkandidat von " + this.tabelle.getName());
            System.out.println("Ergebnis: " 
                    + this.pruefer.kannSchluesselkandidatSein(
                            this.tabelle, von));
        }
    }

}
