package tabelle;


public interface FunktionaleAbhaengigkeitPruefer {
    /**
     * Gegeben sei die Tabelle tabelle mit ihren aktuellen Daten, es wird
     * geprueft, ob eine funktionale Abhaengigkeit zwischen den in von 
     * genannten Attributen (= Spaltenueberschriften) und den in
     * abhaengig genannten Attributen bei den aktuellen Tabelleninhalten
     * geben kann, also {von} &rarr; {abhaengig} gelten kann. 
     * @param tabelle zu untersuchende Tabelle mit zu analysierenden 
     *                Beispieldaten
     * @param von Array mit Spaltennamen, die für die zugehoerige Menge von
     *            Attributen steht, von denen die Attribute in abhaengig
     *            funktional abhaengig sein sollen
     * @param abhaengig Array mit Spaltennamen, die für die zugehoerige Menge
     *            von Attributen steht, deren moegliche funktionale
     *            Abhaengigkeit ueberprueft werden soll
     * @return mit den aktuellen Daten der Tabelle kann die mit abhaengig
     *         beschriebene Attributmenge (Spaltennamen) funktional
     *         abhaengig von der mit von beschriebenen Attributmenge sein?
     */
    public boolean kannFunktionalAbhaengigSein(Tabelle tabelle
            , String[] von, String[] abhaengig);
    
     /**
     * Gegeben sei die Tabelle tabelle mit ihren aktuellen Daten, es wird
     * geprueft, ob eine volle funktionale Abhaengigkeit zwischen den in von 
     * genannten Attributen (= Spaltenueberschriften) und den in
     * abhaengig genannten Attributen bei den aktuellen Tabelleninhalten
     * geben kann, also {von} &rarr; {abhaengig} voll gelten kann.
     * Bei einer vollen funktionalen Abhaengigkeit muss die Menge von minimal
     * sein, es darf kein Attribut entfernt werden koennen und weiterhin
     * eine funktionale Abhaengigkeit gelten. Man beachte, dass sich anders
     * als bei kannFunktionalAbhaengigSein(.), das Ergebnis durch
     * weitere Inhalte auch von false auf true aendern kann.
     * @param tabelle zu untersuchende Tabelle mit zu analysierenden 
     *                Beispieldaten
     * @param von Array mit Spaltennamen, die für die zugehorige Menge von
     *            Attributen steht, von denen die Attribute in abhaengig
     *            voll funktional abhaengig sein sollen
     * @param abhaengig Array mit Spaltennamen, die für die zugehoerige Menge
     *            von Attributen steht, deren moegliche volle funktionale
     *            Abhaengigkeit ueberprueft werden soll
     * @return mit den aktuellen Daten der Tabelle kann die mit abhaengig
     *         beschriebene Attributmenge (Spaltennamen) voll funktional
     *         abhaengig von der mit von beschriebenen Attributmenge sein?
     */
    public boolean kannVollFunktionalAbhaengigSein(Tabelle tabelle
            , String[] von, String[] abhaengig);
    
    /**
     * Gegeben sei die Tabelle tabelle mit ihren aktuellen Daten, es wird
     * geprueft, ob es sich bei der Attributmenge kann bei den
     * aktuell in der Tabelle befindlichen Daten um einen 
     * Schluessel dieser Tabelle handeln kann. 
     * @param tabelle zu untersuchende Tabelle mit zu analysierenden 
     *                Beispieldaten
     * @param kann Menge von Attributen (= Spaltennamen) fuer die geprueft
     *             werden soll, ob es sich um einen Schluessel
     *             der Tabelle tabelle handeln kann
     * @return ist die Attributnmenge kann auf Basis der Datenlage der Tabelle
     *         tabelle ein moeglicher Schluessel?
     */
    public boolean kannSchluesselSein(Tabelle tabelle , String[] kann);
    
    /**
     * Gegeben sei die Tabelle tabelle mit ihren aktuellen Daten, es wird
     * geprueft, ob es sich bei der Attributmenge kann um einen 
     * Schluesselkandidaten dieser Tabelle handeln kann.
     * Bei einem Schluesselkandidaten muss die Menge von Attributen minimal
     * sein, es darf kein Attribut entfernt werden koennen und es sich weiterhin
     * um einen Schluessel handeln. Man beachte, dass sich anders
     * als bei kannSchluesselSein(.), das Ergebnis durch
     * weitere Inhalte auch von false auf true aendern kann. Es ist auch 
     * moeglich, dass echte Schluesselkandidaten auf Basis der Datenlage 
     * nicht als solche erkannt werden.
     * @param tabelle zu untersuchende Tabelle mit zu analysierenden 
     *                Beispieldaten
     * @param kann Menge von Attributen (= Spaltennamen) fuer die geprueft
     *             werden soll, ob es sich um einen Schluesselkandidaten
     *             der Tabelle tabelle handeln kann
     * @return ist die Attributmenge kann auf Basis der Datenlage der Tabelle
     *         tabelle ein moeglicher Schluesselkandidat?
     */
    public boolean kannSchluesselkandidatSein(Tabelle tabelle
            , String[] kann);
}
