package test;

import classmodel.Alle;
import java.util.Arrays;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import tabelle.FunktionaleAbhaengigkeitPruefer;
import tabelle.Tabelle;

/* Alle Tests sind bezgl. der Testwerte korrekt, es sei daran erinnert, dass
   die Testdaten nur Hinweise liefern bzw. einzelne Abhaengigkeiten 
   ausschliessen koennen. Werden die Testinhalte veraendert, machen viele der
   Tests keinen Sinn mehr.
*/
public class SystemTest {
    private static Class<?> clazz;
    
    private FunktionaleAbhaengigkeitPruefer pruefer;
    private Tabelle tabelle = new Tabelle();
    
    @BeforeAll
    public static void setUpOnce(){
        String implementierung = null;
        for (String k : Alle.alleKlassen()) {
            if (Alle.klasseImplementiertInterface(k, "tabelle.FunktionaleAbhaengigkeitPruefer")) {
                implementierung = k;
            }
        }
        if (implementierung == null) {
            System.out.println("keine Klasse gefunden, die das Interface"
              + " tabelle.FunktionaleAbhaengigkeitPruefer realisiert");
            throw new IllegalArgumentException("Keine Implementierung des"
                    + " Interfaces tabelle.FunktionaleAbhaengigkeitPruefer gefunden!");
        }
        clazz = Alle.moeglicheClassObjekteFuer(implementierung).get(0);
    }
    
    @BeforeEach
    public void setUp(){
        try {
            this.pruefer = (FunktionaleAbhaengigkeitPruefer) clazz
                .getDeclaredConstructor().newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException("Implementierung hat keinen"
                    + " nutzbaren parameterlosen Konstruktor: " + e);
        }
        this.tabelle.laden("Vorfuehrung.tabelle");
        Assertions.assertEquals(10
            , this.tabelle.anzahlZeilen()
            , "Anscheinend unsaubere Testdaten, falsche Zeilenzahl");
        Assertions.assertEquals(10
            , this.tabelle.getSpaltenueberschriften().length
            , "Anscheinend unsaubere Testdaten, falsche Spaltenzahl");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein1(){
        String[] von = new String[]{"Kinoname"};
        String[] nach = new String[]{"Kinoname"};
        Assertions.assertTrue(this.pruefer
            .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
            + " sollte gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein2(){
        String[] von = new String[]{"Fassung", "Saal"};
        String[] nach = new String[]{"Groesse"};  // gilt nicht, aber nach Daten moeglich
        Assertions.assertTrue(this.pruefer
            .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
            + " sollte gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein3(){
        String[] von = new String[]{"Kinoname", "Ort", "Saal"};
        String[] nach = new String[]{"Ort", "Fassung", "Groesse"};
        Assertions.assertTrue(this.pruefer
              .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " sollte gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein4(){
        String[] von = new String[]{"Kinoname", "Ort"};
        String[] nach = new String[]{"Fassung"};
        Assertions.assertTrue(this.pruefer
              .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " sollte gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein5(){
        String[] von = new String[]{"Kinoname", "Ort", "Saal"};
        String[] nach = new String[]{"Fassung", "Uhrzeit", "Groesse"};
        Assertions.assertFalse(this.pruefer
              .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " sollte nicht gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein6(){
        String[] von = new String[]{"Tag"};
        String[] nach = new String[]{"Film"};
        Assertions.assertFalse(this.pruefer
              .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " sollte nicht gelten");
    }
    
    @Test
    public void testkannFunktionalAbhaengigSein7(){
        String[] von = new String[]{"Kinoname", "Saal"};
        String[] nach = new String[]{"Groesse"};
        Assertions.assertFalse(this.pruefer
              .kannFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " sollte nicht gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein1(){
        String[] von = new String[]{"Kinoname", "Ort"};
        String[] nach = new String[]{"Fassung"};
        Assertions.assertTrue(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein2(){
        String[] von = new String[]{"Kinoname", "Ort", "Saal"};
        String[] nach = new String[]{"Fassung", "Groesse"};
        Assertions.assertTrue(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein3(){
        String[] von = new String[]{"Film"};
        String[] nach = new String[]{"FSK", "Laenge"};
        Assertions.assertTrue(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein4(){
        String[] von = new String[]{"Kinoname", "Ort" };
        String[] nach = new String[]{"Ort"};
        Assertions.assertFalse(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte nicht gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein5(){
        String[] von = new String[]{"Kinoname", "Ort", "Saal"};
        String[] nach = new String[]{"Fassung"};
        Assertions.assertFalse(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte nicht gelten");
    }
    
    @Test
    public void testkannVollFunktionalAbhaengigSein6(){
        String[] von = new String[]{"Kinoname", "Ort", "Saal"};
        String[] nach = new String[]{"Uhrzeit", "Tag"};
        Assertions.assertFalse(this.pruefer
              .kannVollFunktionalAbhaengigSein(this.tabelle, von, nach)
            , Arrays.asList(von) + " -> " + Arrays.asList(nach)
              + " voll sollte nicht gelten");
    }
    ////////////////////////////////////
    @Test
    public void testkannSchluesselSein1(){
        String[] kandidat = new String[]{"Kinoname", "Ort", "Saal", "Tag", "Uhrzeit"};
        Assertions.assertTrue(this.pruefer
              .kannSchluesselSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte Schluessel sein ");
    }
    
    @Test
    public void testkannSchluesselSein2(){
        String[] kandidat = new String[]{"Kinoname", "Ort", "Saal", "Tag", "Uhrzeit", "Film", "FSK"};
        Assertions.assertTrue(this.pruefer
              .kannSchluesselSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte Schluessel sein ");
    }
    
    @Test
    public void testkannSchluesselSein3(){
        String[] kandidat = new String[]{"Fassung", "Groesse", "Laenge", "Tag", "Uhrzeit"};
        Assertions.assertTrue(this.pruefer
              .kannSchluesselSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte Schluessel sein "); // ist es aber nicht
    }
    
    @Test
    public void testkannSchluesselSein4(){
        String[] kandidat = new String[]{"Kinoname", "Ort", "Saal", "Tag"};
        Assertions.assertFalse(this.pruefer
            .kannSchluesselSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte kein Schluessel sein ");
    }
    
    @Test
    public void testkannSchluesselSein5(){
        String[] kandidat = new String[]{"Film"};
        Assertions.assertFalse(this.pruefer
              .kannSchluesselSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte kein Schluessel sein ");
    }
    
    @Test
    public void testkannSchluesselkandidatSein1(){
        String[] kandidat = new String[]{"Kinoname", "Ort", "Saal", "Tag", "Uhrzeit"};
        Assertions.assertTrue(this.pruefer
              .kannSchluesselkandidatSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte Schluesselkandidat sein ");
    }
    
    @Test
    public void testkannSchluesselkandidatSein2(){
        String[] kandidat = new String[]{"Fassung", "Laenge", "Tag", "Uhrzeit"};
        Assertions.assertTrue(this.pruefer
              .kannSchluesselkandidatSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte Schluesselkandidat sein"); // ist es aber nicht
    }
    
    @Test
    public void testkannSchluesselkandidatSein3(){
        String[] kandidat = new String[]{"Kinoname", "Saal", "Tag", "Uhrzeit"};
        Assertions.assertFalse(this.pruefer
              .kannSchluesselkandidatSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte kein Schluesselkandidat sein ");
    }
    
    @Test
    public void testkannSchluesselkandidatSein4(){
        String[] kandidat = new String[]{"Kinoname", "Saal", "Tag", "Uhrzeit", "Film"};
        Assertions.assertFalse(this.pruefer
              .kannSchluesselkandidatSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte kein Schluesselkandidat sein ");
    }
 
    @Test
    public void testkannSchluesselkandidatSein5(){
        String[] kandidat = new String[]{"Kinoname", "Ort", "Saal", "Tag", "Uhrzeit", "Film"};
        Assertions.assertFalse(this.pruefer
              .kannSchluesselkandidatSein(this.tabelle, kandidat)
            , Arrays.asList(kandidat) + " sollte kein Schluesselkandidat sein ");
    }    
}
