package test;

import dialog.Studierendenbearbeitung;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.github.stefanbirkner.systemlambda.SystemLambda;


public class SystemTest {

    private Studierendenbearbeitung bearbeitung;

    private List<String[]> beispiele ;

    @BeforeEach
    public void setUp() {
        this.bearbeitung = new Studierendenbearbeitung();
        this.beispiele = Arrays.asList(
                new String[][]{
              {"Ute", "42", "WiSe16"}
            , {"Ulf", "43", "WiSe16"}
            , {"Sergej", "44", "SoSe15"}
            , {"Ahmad", "45", "SoSe15"}
            , {"Jan", "46", "WiSe15"}
            , {"Jim", "47", "WiSe09"}
            , {"Jana", "48", "WiSe15"}
            , {"Esra", "49", "WiSe15"}
        });
        if(!this.bearbeitung.verbinden()){
            throw new IllegalArgumentException("Probleme mit DB-Verbindung");
        }
        this.bearbeitung.studisLoeschen();
    }
    
    @AfterEach
    public void tearDown() {
        this.bearbeitung.studisLoeschen();
        this.bearbeitung.schliessen();
    }

    private String studiHinzu(String... daten) throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        SystemLambda.withTextFromSystemIn(daten)
        .execute(() -> {
          this.bearbeitung.studiHinzu();
        });
      });
    }

    private String alleStudis() throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        this.bearbeitung.alleStudis();
      });
    }

    private String studiNameAendern(int mat, String name) throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        SystemLambda.withTextFromSystemIn(new String[]{mat + "", name})
        .execute(() -> {
          this.bearbeitung.studinamenAendern();
        });
      });
    }

    private String studisLoeschen() throws Exception {
      return SystemLambda.tapSystemOutNormalized(() -> {
        this.bearbeitung.studisLoeschen();
      });
    }

    private void beispiele() throws Exception {
        for (String[] s : this.beispiele) {
            this.studiHinzu(s);
        }
    }

    private List<String[]> analyse(String log) {
        String[] stud = log.split("\\)\\R");
        // System.out.println(stud.length + " stud: " + Arrays.asList(stud));
        List<String[]> ergebnisse = new ArrayList<>();
        for (String s : stud) {
            if(s.length() > 3){ // eleminiert Restzeilen
                String[] daten = s.split("(: )|( \\()");
                // System.out.println("daten :" + Arrays.asList(daten));
                String[] tmp = {daten[0], daten[1], daten[2]};
                // System.out.println("tmp :" + Arrays.asList(tmp));
                ergebnisse.add(tmp);
            }
        }
        return ergebnisse;
    }

    private String vergleichen(List<String[]> daten, List<String[]> beispiele) {
        if (daten.size() != beispiele.size()){
            return "Erwartet wurden " + beispiele.size() + " Ergebnisse "
                    + "gefunden wurden " + daten.size() + " Ergebnisse";
        }
        for(String[] d: beispiele){
            String[] gefunden = null;
            for(String[] v: daten){
                if(d[0].equals(v[1]) && d[1].equals(v[0]) && d[2].equals(v[2])){
                    gefunden = v;
                }
            }
            if (gefunden != null){
                daten.remove(gefunden);
            }
        }
        if(!daten.isEmpty()){
            return daten.size() + " falsche Datensaetze gefunden, "
                    + "u. a. " + Arrays.asList(daten.get(0));
        }
        return "";
    }
    
    @Test
    public void leererStart() throws Exception {
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals(0, daten.size()
            , "Tests laufen nur, wenn noch keine "
                + "Daten abgespeichert sind");
    }

    @Test
    public void beispieldatenKorrektEingespielt() throws Exception {
        this.beispiele();       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten,this.beispiele));
    }
    
    @Test
    public void ersterEintrag() throws Exception{
        String[] data = {"Sarah","42","WiSe21"};
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(data);
        this.studiHinzu(data);      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
    
    @Test
    public void korrekterNeuerEintrag() throws Exception{
        this.beispiele();
        String[] data = {"Sarah","50","WiSe22"};
        List<String[]> erwartet = new ArrayList<>();
        erwartet.add(data);
        erwartet.addAll(this.beispiele);
        this.studiHinzu(data);      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, erwartet));        
    }
    
    @Test
    public void doppelterNeuerEintrag() throws Exception{
        this.beispiele();
        String[] data = {"Sarah","44","WiSe17"};
        this.studiHinzu(data);       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }
         
    @Test
    public void nameErfolgreichAendern() throws Exception{
        this.beispiele();
        this.studiNameAendern(49, "Elif");        
        List<String[]> daten = this.analyse(this.alleStudis());
        this.beispiele.get(7)[0] = "Elif";
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }

    @Test
    public void nameErfolglosAendern() throws Exception{
        this.beispiele();
        this.studiNameAendern(50, "Elif");       
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals("", this.vergleichen(daten, this.beispiele));        
    }
    
    @Test
    public void nameErfolglosBeiLeeremDatenbestandAendern() throws Exception{
        this.studiNameAendern(50, "Elif");      
        List<String[]> daten = this.analyse(this.alleStudis());
        Assertions.assertEquals(0, daten.size()
            , "Keine Datensaetze erwartet");        
    }
    
    @Test
    public void testStudisLoeschen() throws Exception{
      this.beispiele();
      this.studisLoeschen();      
      List<String[]> daten = this.analyse(this.alleStudis());
      List<String[]> erwartet = new ArrayList<>();
      Assertions.assertEquals("", this.vergleichen(daten, erwartet)); 
    }
}
