package control;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class Bildverwaltung {
	private Connection con;
	private Statement stmt;

	public boolean starten() {
		try {
			Class.forName("org.apache.derby.jdbc.ClientDriver").getDeclaredConstructor().newInstance();
			this.con = DriverManager.getConnection("jdbc:derby://localhost:1527/F:\\tmp\\Bilder;create=true", "kleuker",
					"kleuker");
			this.con.setAutoCommit(true);
			this.stmt = con.createStatement();
			return true;
		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
				| NoSuchMethodException | SecurityException | ClassNotFoundException | SQLException e) {
			System.out.println("Problem beim Oeffnen: " + e);
			return false;
		}
	}

	public boolean schreibeDaten(String datei) {
		try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO Bild VALUES (?, ?)");
				var ins = new FileInputStream(datei);
				ResultSet max = this.stmt.executeQuery("SELECT MAX(Bild.nr) FROM Bild")) {
			max.next();
			ps.setInt(1, max.getInt(1) + 1);
			ps.setBinaryStream(2, ins);
			ps.execute();
			System.out.println("Eingespielt " + datei);
			return true;
		} catch (Exception e) {
			System.out.println("Problem beim Einspielen von " + datei + ": " + e);
			return false;
		}
	}
	
	public boolean leseDaten(int id, String zieldatei) {
		try(ResultSet rs = this.stmt.executeQuery(
				"SELECT Bild.Datei FROM Bild WHERE Bild.nr=" + id)){
		if(!rs.next()) {
			System.out.println("Bild mit Nummer " + id + " nicht gefunden");
			return false;
		}
		byte buf[] = new byte[1024];
	    Blob blob = rs.getBlob(1);
	    File file = new File(zieldatei);
	    try(
	    		InputStream in = blob.getBinaryStream();
	    		FileOutputStream out = new FileOutputStream(file)){
	    for (int b = in.read(buf); b != -1; b = in.read(buf)) {
            out.write(buf, 0, b);
        }
	    return true;
	    }catch (Exception e) {
			System.out.println("Problem beim Lesen von " +id + " in "+ zieldatei + ": " + e);
			return false;
		}
		}catch (Exception e) {
			System.out.println("Problem beim Vorbereiten des Lesens von " +id + " in "+ zieldatei + ": " + e);
			return false;
		}
	    
	}

	public void zeigeDaten() {
		System.out.println("Daten");
		try (ResultSet rs = stmt.executeQuery("SELECT * FROM Bild")) {
			// ResultSet rs = stmt.executeQuery("SELECT * FROM Bild");
			ResultSetMetaData rsmd = rs.getMetaData();
			int spalten = rsmd.getColumnCount();
			while (rs.next()) {
				for (int i = 1; i <= spalten; i++) {
					System.out.print(rs.getObject(i) + " ");
				}
				System.out.print("\n");
			}
			// rs.close();
		} catch (Exception e) {
			System.out.println("Problem beim Zeigen der Daten: " + e);
		}
	}

	public void schliessen() {
		try {
			this.con.commit();
			if (!this.stmt.isClosed()) {
				this.stmt.close();
			}
			if (!this.con.isClosed()) {
				this.con.close();

			}
		} catch (SQLException ex) {
			System.out.println("Problem beim Schliessen: " + ex);
		}
	}
}
