DROP TABLE Studi;

CREATE TABLE Studi(
  Mat INTEGER,
  Name VARCHAR(29) UNIQUE,
  Fach VARCHAR(4) NOT NULL,
  Jahr INTEGER NOT NULL,
  CP INTEGER NOT NULL,
  CONSTRAINT Primaerschluessel PRIMARY KEY (Mat),
  CONSTRAINT Matrikel6Stellig CHECK(Mat >= 100000),
  -- wenn Jahr <1900 dann muss Fach=ZOM
  -- A Jahr<1900   B Fach='ZOM'  NOT(A) OR B
  --    F           F            T
  --    F           T            T
  --    T           T            T
  --    T           F            F      
  CONSTRAINT AlteZombies CHECK (NOT(Jahr <1900) OR Fach='ZOM')
);

INSERT INTO Studi VALUES(100042,'Ute','ITI',1990,0);
INSERT INTO Studi VALUES(100045, NULL,'ITI',1992,0);
INSERT INTO Studi VALUES(100046,'Wilhelm','ZOM',1888,0);
INSERT INTO Studi VALUES(100047,'Wilhelm2','ZOM',1998,0);
INSERT INTO Studi VALUES(100048,'Wilhelm0','IMI',1888,0);
INSERT INTO Studi VALUES(100048,'Wilhelm0','ZOM',1888,0);
SELECT * FROM Studi;
