package builder;

import entity.Fachgebiet;
import entity.Mitarbeitend;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MitarbeitendBuilderTest {

  @Test
  public void testBasisobjekt() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva")
    		, "Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		, "Nachname erwartet 'Mustermann', gefunden:'"
            + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList());
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testNeuerVorname() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .vorname("Sergej")
        .build();
    Assertions.assertTrue(m.getVorname().equals("Sergej")
    		, "Vorname erwartet 'Sergej', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		, "Nachname erwartet 'Mustermann', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList());
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testNeuerNachname() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .nachname("Eydin")
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva")
    		, "Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Eydin")
    		, "Nachname erwartet 'Eydin', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList());
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testEineNeueFaehigkeit() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .mitFachgebiet(Fachgebiet.C)
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva")
    		,"Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		, "Nachname erwartet 'Mustermann', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList(Fachgebiet.C));
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [C], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testMehrereFaehigkeiten() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .mitFachgebiet(Fachgebiet.C)
        .mitFachgebiet(Fachgebiet.JAVA)
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva"),
    		"Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		,"Nachname erwartet 'Mustermann', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList(Fachgebiet.JAVA, Fachgebiet.C));
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [Java, C], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testDoppelteFaehigkeiten() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .mitFachgebiet(Fachgebiet.ANALYSE)
        .mitFachgebiet(Fachgebiet.C)
        .mitFachgebiet(Fachgebiet.JAVA)
        .mitFachgebiet(Fachgebiet.ANALYSE)
        .mitFachgebiet(Fachgebiet.C)
        .mitFachgebiet(Fachgebiet.JAVA)
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva")
    		,"Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		,"Nachname erwartet 'Mustermann', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(
        Arrays.asList(Fachgebiet.JAVA, Fachgebiet.C, Fachgebiet.ANALYSE));
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		,"Erwartete Faehigkeiten: [Java, C, Analyse], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void nachtraeglicheAenderung() {
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .vorname(("Egon"))
        .nachname("Meier")
        .nachname("Eydin")
        .vorname("Anna")
        .build();
    Assertions.assertTrue(m.getVorname().equals("Anna")
    		, "Vorname erwartet 'Anna', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Eydin")
    		, "Nachname erwartet 'Eydin', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(Arrays.asList());
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [], gefunden: "
    		        + m.getFachgebiete());
  }

  @Test
  public void testMehrfacheNutzung() {
    MitarbeitendBuilder mb = MitarbeitendBuilder
        .createBuilder()
        .vorname("Tyrion")
        .nachname("Lannister");
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .vorname("Daenerys")
        .nachname("Targaryen")
        .build();
    Mitarbeitend m2 = mb.build();
    Assertions.assertTrue(!m.getVorname().equals(m2.getVorname())
            && !m.getNachname().equals(m2.getNachname())
            , "geschachtelte Erzeugung  unterschiedlicher"
                    + "Objekte klappt nicht");
  }

  @Test
  public void testNacheinandernutzung() {
    Mitarbeitend m0 = MitarbeitendBuilder
        .createBuilder()
        .mitFachgebiet(Fachgebiet.ANALYSE)
        .mitFachgebiet(Fachgebiet.C)
        .mitFachgebiet(Fachgebiet.DESIGN)
        .build();
    Mitarbeitend m = MitarbeitendBuilder
        .createBuilder()
        .mitFachgebiet(Fachgebiet.TEST)
        .mitFachgebiet(Fachgebiet.C)
        .mitFachgebiet(Fachgebiet.JAVA)
        .build();
    Assertions.assertTrue(m.getVorname().equals("Eva")
    		, "Vorname erwartet 'Eva', gefunden:'"
    		        + m.getVorname() + "'");
    Assertions.assertTrue(m.getNachname().equals("Mustermann")
    		, "Nachname erwartet 'Mustermann', gefunden:'"
    		        + m.getNachname() + "'");
    Set<Fachgebiet> tmp = new HashSet<>();
    tmp.addAll(
        Arrays.asList(Fachgebiet.JAVA, Fachgebiet.C, Fachgebiet.TEST));
    Assertions.assertTrue(m.getFachgebiete().equals(tmp)
    		, "Erwartete Faehigkeiten: [Java, C, Test], gefunden: "
    		        + m.getFachgebiete());
  }
  
  @Test
  public void testErwarteteExcption() {
    try {
      MitarbeitendBuilder
          .createBuilder()
          .mitFachgebiet(Fachgebiet.ANALYSE)
          .mitFachgebiet(Fachgebiet.C)
          .mitFachgebiet(Fachgebiet.JAVA)
          .mitFachgebiet(Fachgebiet.TEST)
          .build();
      Assertions.fail("Erwartete Exception bei 4 Fachgebieten fehlt.");
    } catch (IllegalArgumentException e) {
    }
  }
}
