package main;

import java.util.regex.Pattern;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.github.stefanbirkner.systemlambda.SystemLambda;

import controller.Controller;

public class SystemTest {
       
    private Controller controller;
    
    @BeforeEach
    public void setUp(){
        this.controller = new Controller();
    }
    
    private void viewHinzu(String zeichen) throws Exception{
        String[] inputs = {zeichen};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.controller.neuerView();
        });
    }
    
    private String controllerNutzen(int anzahl) throws Exception{
        String[] inputs = {""+anzahl};
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.controller.controllerNutzen();
          });
        });
        return systemOut.split("\\(0\\)")[0];
    }
    
    @Test
    public void testOhneView() throws Exception{
        String erg = this.controllerNutzen(42);
        Assertions.assertEquals("neuer Modellwert: ", erg
            , "keine Zeichenausgabe erwartet");
    }
    
    @Test
    public void testEinView() throws Exception{
        this.viewHinzu("xxxBlubb");
        String erg = this.controllerNutzen(8);
        Assertions.assertTrue(Pattern.matches("(?s)[^x]*xxxxxxxx[^x]*", erg)
            , "genau 8 x in Ausgabe erwartet: " + erg);
    }
    
    @Test
    public void testMehrereViews() throws Exception{
        this.viewHinzu("xxxBlubb");
        this.viewHinzu("yyyBlubb");
        this.viewHinzu("zzzBlubb");
        String erg = this.controllerNutzen(8);
        Assertions.assertTrue(Pattern.matches("(?s)[^x]*xxxxxxxx[^x]*", erg)
            , "genau 8 x in Ausgabe erwartet: " +erg);
        Assertions.assertTrue(Pattern.matches("(?s)[^y]*yyyyyyyy[^y]*", erg)
            , "genau 8 y in Ausgabe erwartet: " +erg);
        Assertions.assertTrue(Pattern.matches("(?s)[^z]*zzzzzzzz[^z]*", erg)
            , "genau 8 z in Ausgabe erwartet: " +erg);
    }
    
    @Test
    public void testZusammen() throws Exception{
        String[] inputs = {"2","4","1","qqq","2","4","1","yyy","2","9","0"};
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.controller.dialog();
          });
        });
        Assertions.assertTrue(Pattern.matches("(?s)[^q]*qqqq[^q]*qqqqqqqqq[^q]*"
              , systemOut)
            , "genau 4 q  und danach 9 q in Ausgabe erwartet: " + systemOut);
        Assertions.assertTrue(Pattern.matches("(?s)[^y]*yyyyyyyyy[^y]*"
              , systemOut)
            , "genau 9 y in Ausgabe erwartet: " + systemOut);
    }
}
