package test;

import java.util.regex.Pattern;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.github.stefanbirkner.systemlambda.SystemLambda;

import main.Dialog;

public class SystemTest {

    private Dialog dialog;

    @BeforeEach
    public void setUp() {
        this.dialog = new Dialog();
    }

    private void mitarbeitendAnlegen(String name, int nr) throws Exception {
        String[] inputs = {name, "" + nr};
        SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.mitarbeitHinzufuegen();
          });
    }

    private void projektAnlegen(String name) throws Exception {
        String[] inputs = {name};
        SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.projektwhiteboardHinzufuegen();
          });
    }

    private void abteilungAnlegen(String name, int nr) throws Exception {
        String[] inputs = {name, "" + nr};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.abteilungswhiteboardHinzufuegen();
        });        
    }

    private void mitarbeitInProjekt(int posm, int posp)  throws Exception{
        String[] inputs = {"" + posm, "" + posp};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.mitarbeiterAnmelden();
        });
    }

    private void projektZuAbteilung(int posp, int posa) throws Exception {
        String[] inputs = {"" + posp, "" + posa};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.projektAnmelden();
        });
    }

    private void infoInProjekt(int pos, String nachricht) throws Exception {
        String[] inputs = {"" + pos, nachricht};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.projektwhiteboardBeschreiben();
        });
    }

    private void infoInAbteilung(int pos, String nachricht) throws Exception {
        String[] inputs = {"" + pos, nachricht};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.abteilungswhiteboardBeschreiben();
        });
    }

    private String datenZeigen() throws Exception {
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.dialog.uebersichtAnzeigen();
        });
        return systemOut;
    }

    @Test
    public void gesamtdialogTest() throws Exception {
        String[] inputs = {"1", "Anna Nase", "1234", "0"};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.schleife();
        });
    }

    @Test
    public void mitarbeitendAnlegenTest() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        String systemOut = this.datenZeigen();
        Assertions.assertTrue(systemOut.contains("Anna Nase")
                && systemOut.contains("42")
                , "Anna Nase(42) in Mitarbeiterliste nicht gefunden: "
                    + systemOut);
    }

    @Test
    public void projektAnlegenTest() throws Exception {
        this.projektAnlegen("Perpetuum");
        String systemOut = this.datenZeigen();
        Assertions.assertTrue(systemOut.contains("Perpetuum")
            , "Perpetuum in Projektliste nicht gefunden: "
                + systemOut);
    }

    @Test
    public void abteilungAnlegenTest() throws Exception {
        this.abteilungAnlegen("Shield", 4242);
        String systemOut = this.datenZeigen();
        Assertions.assertTrue(systemOut.contains("Shield")
                && systemOut.contains("4242")
                , "Shield in Abteilungssliste nicht gefunden: "
                    + systemOut);
    }

    @Test
    public void mitarbeitendInProjektTest() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        String systemOut = this.datenZeigen();

        Assertions.assertTrue(Pattern.matches("(?s).*Perpetuum.*Anna.*Nase.*42.*"
                        , systemOut)
            , "Anna Nase(42) in Projekt Perpetuum nicht gefunden: "
                + systemOut);
    }

    @Test
    public void projektInAbteilungTest() throws Exception {
        this.projektAnlegen("Perpetuum");
        this.abteilungAnlegen("Shield", 4242);
        this.projektZuAbteilung(1, 1);
        String systemOut = this.datenZeigen();

        Assertions.assertTrue(Pattern.matches("(?s).*Shield.*4242.*Perpetuum.*"
                        , systemOut)
            , "Projekt Perpetuum nicht in Abteilung Shield gefunden: "
                + systemOut);
    }

    @Test
    public void nachrichtAnProjektTest() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        this.mitarbeitInProjekt(1, 2);
        this.mitarbeitInProjekt(2, 2);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInProjekt(1, "Xulu");
        });
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Sergej.*Xulu.*"
                        , systemOut)
                || Pattern.matches("(?s).*Sergej.*Xulu.*Anna.*Xulu.*"
                        , systemOut)
                , "Nachricht Xulu nicht an Anna und Sergej geschickt: "
                    + systemOut
        );
    }

    @Test
    public void nachrichtAnProjekt2Test() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        this.mitarbeitInProjekt(1, 2);
        this.mitarbeitInProjekt(2, 2);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInProjekt(2, "Xulu");
        });
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Edna.*Xulu.*"
                        , systemOut)
                || Pattern.matches("(?s).*Edna.*Xulu.*Anna.*Xulu.*"
                        , systemOut)
                , "Nachricht Xulu nicht an Anna und Edna geschickt: "
                    + systemOut
        );
    }

    @Test
    public void nachrichtAnProjekt3Test() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInProjekt(2, "Xulu");
        });
        Assertions.assertTrue(Pattern.compile("Xulu")
                .split(systemOut).length == 1
                , "Nachricht Xulu irrtuemlich verschickt: "
                    + systemOut);
    }

    @Test
    public void nachrichtAnAbteilungTest() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        this.mitarbeitInProjekt(1, 2);
        this.mitarbeitInProjekt(2, 2);
        this.abteilungAnlegen("Shield", 4242);
        this.projektZuAbteilung(1, 1);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInAbteilung(1, "Xulu");
        });
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Sergej.*Xulu.*"
                        , systemOut)
                || Pattern.matches("(?s).*Sergej.*Xulu.*Anna.*Xulu.*"
                        , systemOut)
                , "Nachricht Xulu nicht an Anna und Sergej geschickt: "
                    + systemOut
        );
        
    }

    @Test
    public void nachrichtAnAbteilung2Test() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        this.mitarbeitInProjekt(1, 2);
        this.mitarbeitInProjekt(2, 2);
        this.abteilungAnlegen("Shield", 4242);
        this.abteilungAnlegen("NCIS", 4243);
        this.projektZuAbteilung(1, 1);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInAbteilung(2, "Xulu");
        });
        Assertions.assertTrue(Pattern.compile("Xulu")
                .split(systemOut).length == 1
                , "Nachricht Xulu irrtuemlich verschickt: "
                    + systemOut);
    }

    @Test
    public void nachrichtAnAbteilung3Test() throws Exception {
        this.mitarbeitendAnlegen("Anna Nase", 42);
        this.projektAnlegen("Perpetuum");
        this.mitarbeitInProjekt(1, 1);
        this.mitarbeitendAnlegen("Edna Nase", 43);
        this.mitarbeitendAnlegen("Sergej Nase", 44);
        this.mitarbeitInProjekt(3, 1);
        this.projektAnlegen("Zero");
        this.mitarbeitInProjekt(1, 2);
        this.mitarbeitInProjekt(2, 2);
        this.abteilungAnlegen("Shield", 4242);
        this.projektZuAbteilung(1, 1);
        this.projektZuAbteilung(2, 1);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.infoInAbteilung(1, "Xulu");
        });
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Sergej.*Xulu.*"
                        , systemOut)
                || Pattern.matches("(?s).*Sergej.*Xulu.*Anna.*Xulu.*"
                        , systemOut)
                , "Nachricht Xulu nicht an Anna und Sergej geschickt: "
                    + systemOut
        );
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Edna.*Xulu.*"
                        , systemOut)
                || Pattern.matches("(?s).*Edna.*Xulu.*Anna.*Xulu.*"
                        , systemOut)
                , "Nachricht Xulu nicht an Anna und Edna geschickt: "
                    + systemOut
        );
        Assertions.assertTrue(Pattern.matches("(?s).*Anna.*Xulu.*Anna.*Xulu.*"
              , systemOut)
            , "Nachricht Xulu nicht doppelt an Anna geschickt: "
                  + systemOut);
    }
}
