package main;

import classmodel.Alle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class StrukturUndBasisTests {
        // besser in einzelne Tests aufspalten
    private static String[] geforderteKlassen = {"Ausruestung", "Waffe", "Ruestung"
            , "Conan", "Xenia", "Blobb", "SchwarzerRitter", "Kaempfend"
    };
    
    private static String[][][] geforderteMethoden ={
        {{"Waffe"},{"int"},{"zuhauen"},{"int"}} 
            , {{"Ruestung"},{"int"},{"abwehr"},{"int"}}
            , {{"Conan"},{"int"},{"kaempfen"},{}}
            , {{"Conan"},{"int"},{"abwehren"},{"int"}}
            , {{"Conan"},{"void"},{"nimmWaffe"},{"Waffe"}}
            , {{"Conan"},{"void"},{"nimmRuestung"},{"Ruestung"}}
            , {{"Xenia"},{"int"},{"kaempfen"},{}}
            , {{"Xenia"},{"int"},{"abwehren"},{"int"}}
            , {{"Xenia"},{"void"},{"nimmWaffe"},{"Waffe"}}
            , {{"Xenia"},{"void"},{"nimmRuestung"},{"Ruestung"}}
            , {{"Blobb"},{"int"},{"kaempfen"},{}}
            , {{"Blobb"},{"int"},{"abwehren"},{"int"}}
            , {{"Blobb"},{"void"},{"nimmWaffe"},{"Waffe"}}
            , {{"Blobb"},{"void"},{"nimmRuestung"},{"Ruestung"}}
            , {{"Kaempfend"},{"int"},{"kaempfen"},{}}
            , {{"Kaempfend"},{"int"},{"abwehren"},{"int"}}
            , {{"Kaempfend"},{"void"},{"nimmWaffe"},{"Waffe"}}
            , {{"Kaempfend"},{"void"},{"nimmRuestung"},{"Ruestung"}}
            , {{"SchwarzerRitter"},{"int"},{"kaempfen"},{}}
            , {{"SchwarzerRitter"},{"int"},{"abwehren"},{"int"}}
            , {{"SchwarzerRitter"},{"void"},{"nimmWaffe"},{"Waffe"}}
            , {{"SchwarzerRitter"},{"void"},{"nimmRuestung"},{"Ruestung"}}
    };
    
    private static String[][][] geforderteKonstruktoren ={
        {{"Ausruestung"},{"String","int"}}
            ,{{"Waffe"},{"String","int", "int"}}
            ,{{"Conan"},{"int", "int", "int"}}
            ,{{"Xenia"},{"int", "int", "int"}}
            ,{{"Blobb"},{"int", "int", "int"}}
            ,{{"Kaempfend"},{"int", "int", "int"}}
            ,{{"SchwarzerRitter"},{}}
    }; 
    
    private static String[][][] geforderteVariablen = {
        {{"Ausruestung"},{"name"},{"String"}, {"protected"}}
            , {{"Ausruestung"},{"preis"},{"int"}, {"protected"}}    
            , {{"Waffe"},{"staerke"},{"int"}, {"private"}} 
            , {{"Ruestung"},{"schutz"},{"int"}, {"private"}} 
            , {{"Conan"},{"ruestung"},{"Ruestung"}, {"private"}}  
            , {{"Xenia"},{"ruestung"},{"Ruestung"}, {"private"}}
            , {{"Xenia"},{"waffe"},{"Waffe"}, {"private"}}
            , {{"Blobb"},{"waffe"},{"Waffe"}, {"private"}}
            , {{"Kaempfend"},{"gesundheit"},{"int"}, {"protected"}}
            , {{"Kaempfend"},{"geschick"},{"int"}, {"protected"}}
            , {{"Kaempfend"},{"sold"},{"int"}, {"protected"}}
            
    };
    
    private static Object[][][] geforderteVererbungen = {
             {{"Waffe"}, {"Ausruestung"}}
            ,{{"Waffe"}, {"Ausruestung"}}
            ,{{"Conan"}, {"Kaempfend"}} 
            ,{{"Xenia"}, {"Kaempfend"}} 
            ,{{"Blobb"}, {"Kaempfend"}}
            ,{{"SchwarzerRitter"}, {"Kaempfend"}} 
    };
    
    private static Object[][][] geforderteErgebnisse ={     
    };
    
    @ParameterizedTest 
    @MethodSource("klassen")
    public void testKlassenExistieren(String klasse){
            Assertions.assertTrue(Alle.findeKlasse(klasse).size() > 0
                , "Klasse " + klasse + " nach Aufgabe gefordert");
    }
    
    private static String[] klassen(){
        return geforderteKlassen;
    }
      
    @ParameterizedTest 
    @MethodSource("methoden")
    public void testMethodenExistieren(String[][] methode){
            String klasse = methode[0][0];
            String rueckgabetyp = methode[1][0];
            String name = methode[2][0];
            String[] parametertypen = methode[3];
            
            Assertions.assertTrue(Alle.klasseHatMethodeParametertypenUnbekannt(klasse
                            , rueckgabetyp, name, parametertypen).size() > 0
                , "geforderte Methode " + klasse + ": " + name 
                + "(" +Arrays.asList(parametertypen) +"): " 
                + rueckgabetyp + " nicht gefunden");           
    }
        
    private static String[][][] methoden(){
        return geforderteMethoden;
    }
    
    @ParameterizedTest 
    @MethodSource("konstruktoren")
    public void testKonstruktorenExistieren(String[][] methode){
            String klasse = methode[0][0];
            String[] parametertypen = methode[1];
            Assertions.assertTrue(Alle.klasseHatKonstruktorParametertypenUnbekannt(klasse
                            , parametertypen).size() > 0
                , "geforderter Konstruktor " + klasse +"(" 
                    +Arrays.asList(parametertypen) + " nicht gefunden");           
    }  
    
    private static String[][][] konstruktoren(){
        return geforderteKonstruktoren;
    }
    
    @ParameterizedTest 
    @MethodSource("variablen")
    public void testVariablenExistieren(String[][] var){
            String klasse = var[0][0];
            String name = var[1][0];
            String typ = var[2][0];
            String[] sichtbar = var[3]; 
            Assertions.assertTrue(Alle.klasseHatVariableVomTypMitSichtbarkeitUndArt(klasse
                            , name, typ, sichtbar)
                , "Geforderte Variable " + name + " in Klasse"
                    + klasse + " mit Typ " + typ + " fehlt");
    }
    
    private static String[][][] variablen(){
        return geforderteVariablen;
    }
    
    @ParameterizedTest 
    @MethodSource("variablen")
    public void geforderteGetUndSetMethoden(String[][] var){
            String klasse = var[0][0];
            String name = var[1][0];
            String typ = var[2][0];
            Assertions.assertTrue(Alle.klasseHatMethodeParametertypenUnbekannt(klasse, typ
                            , "get"+upper(name)).size() > 0
                , "Zur geforderten Variable " + name + " in Klasse "
                    + klasse + " mit Typ " + typ + " fehlt die get-Methode");
            Assertions.assertTrue(Alle.klasseHatMethodeParametertypenUnbekannt(klasse, "void"
                            , "set"+upper(name), typ).size() > 0
                , "Zur geforderten Variable " + name + " in Klasse "
                    + klasse + " mit Typ " + typ + " fehlt die set-Methode");               
    }
    
    private String upper(String name){
        String tmp = name.toUpperCase();
        return tmp.charAt(0) + name.substring(1);
    }
    
    @ParameterizedTest 
    @MethodSource("vererbungen")
    public void testGeforderteVererbungen(Object[][] erbe){
            Assertions.assertTrue(Alle.erbtVon(erbe[0][0].toString(), erbe[1][0].toString())
                , "Klasse " + erbe[0][0] + " sollte von " + erbe[1][0]
                    + " erben");
    }
    
    private static Object[][][] vererbungen(){
        return geforderteVererbungen;
    }
    
//    @Test
//    //@Ignore // enthaelt hier keine Tests
//    @Parameters(method = "methodenergebnisse")
//    public void testMethodenLiefernErgebnisse(Object[][] methode){
//            String klasse = methode[0][0].toString();
//            String rueckgabetyp = methode[1][0].toString();
//            String name = methode[2][0].toString();
//            String[] parametertypen = alsStrings(methode[3]);
//            String ergebnis = methode[4][0].toString();
//            Object[] aufrufwerte = methode[5]; 
//            Method m = Alle.klasseHatMethodeParameterUnbekannt(klasse
//                           , rueckgabetyp, name, parametertypen)
//                      .get(0);
//            Assertions.assertTrue("Methode " + klasse + ": " + name 
//                    + "(" +Arrays.asList(parametertypen) +"): " + rueckgabetyp 
//                    + " liefert mit Parametern " + Arrays.asList(aufrufwerte) 
//                    +" nicht geforderten Wert " + ergebnis
//                    , Alle.methodeLiefertErgebnis(ergebnis, m));           
//    }
    
    private static Object[][][] methodenergebnisse(){
        return geforderteErgebnisse;
    }
    
    private String[] alsStrings(Object[] arr){
        String[] ergebnis = new String[arr.length];
        for(int i=0; i < arr.length; i++){
            ergebnis[i] = arr[i].toString();
        }
        return ergebnis;
    }
    
    @Test
    // Conan muss Variable mit Namen waffen haben, die zwei Waffen-Objekte
    // enthalten kann; dies kann Collection oder Array sein
    public void testGenutzteSammlung(){
        List<String> typen = Alle.klasseHatVariableMitName("Conan", "waffen");
        String waffe = Alle.findeKlasse("Waffe").get(0);
        boolean gefunden = false;
        for(String typ:typen){
            if (Alle.klasseImplementiertInterface(typ, "java.util.Collection")
                    || typ.equals("[L" + waffe+";")){
                gefunden = true;
            }
        }
        Assertions.assertTrue(gefunden
            , "Variable waffen in Conan sollte "
                + "Array oder Standard-Collection nutzen");
    }
    
    private static List<Object> waffen(){
        List<Object> ergebnis = new ArrayList<>();
        Constructor<?> con = Alle.klasseHatKonstruktorParametertypenBekannt("Waffe"
                , String.class, int.class, int.class).get(0);
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Waffe0", 0, 20));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Waffe10", 10, 30));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Waffe6", 6, 20));
        return ergebnis;
    }

    private static List<Object> ruestung(){
        List<Object> ergebnis = new ArrayList<>();
        Constructor<?> con = Alle.klasseHatKonstruktorParametertypenBekannt("Ruestung"
                , String.class, int.class, int.class).get(0);
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Ruestung0", 0, 20));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Ruestung10", 10, 30));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, "Ruestung6", 6, 20));
        return ergebnis;
    } 
    
     private static List<Object> kaempfend(){
        List<Object> ergebnis = new ArrayList<>();
        Constructor<?> con = Alle.klasseHatKonstruktorParametertypenBekannt("Conan"
                , int.class, int.class, int.class).get(0);
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 0, 20));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 10, 30));
        con = Alle.klasseHatKonstruktorParametertypenBekannt("Xenia", int.class
                , int.class, int.class).get(0);
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 0, 20));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 10, 30));
        con = Alle.klasseHatKonstruktorParametertypenBekannt("Blobb", int.class
                , int.class, int.class).get(0);
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 0, 20));
        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con, 100, 10, 30));
//        con = Alle.klasseHatKonstruktorParameterBekannt("SchwarzerRitter").get(0);
//        ergebnis.add(Alle.erzeugeObjektMitKonstruktor(con));
        return ergebnis;
    }  
     
     @ParameterizedTest 
     @MethodSource("waffen")
    public void testWaffen1(Object waffe){
        Method m = Alle.klasseHatMethodeParametertypenBekannt("Waffe", int.class
                , "zuhauen", int.class).get(0);
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(waffe, m, 0);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode zuhauen muss immer nicht negativen "
                + "Wert liefern (geschick=0)");
    } 

     @ParameterizedTest 
     @MethodSource("waffen")
    public void testWaffen2(Object waffe){
        Method m = Alle.klasseHatMethodeParametertypenBekannt("Waffe", int.class
                , "zuhauen", int.class).get(0);
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(waffe, m, 10);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode zuhauen muss immer nicht negativen Wert "
                + "liefern (geschick=10)");
    }  
    
     @ParameterizedTest 
     @MethodSource("ruestung")
    public void testRuestung1(Object ruestung){
        Method m = Alle.klasseHatMethodeParametertypenBekannt("Ruestung", int.class
                , "abwehr", int.class).get(0);
        int angriff = 0;
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(ruestung, m
                , angriff);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode abwehr muss immer nicht negativen Wert "
                + "liefern (angriff=0)");
        Assertions.assertTrue(((int)erg) <= angriff
            , "Methode abwehr darf Angriffswert nicht vergroessern,"
                + " vorher 0, jetzt " + erg);        
    } 

     @ParameterizedTest 
     @MethodSource("ruestung")
    public void testRuestung2(Object ruestung){
        Method m = Alle.klasseHatMethodeParametertypenBekannt("Ruestung", int.class
                , "abwehr", int.class).get(0);
        int angriff = 10;
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(ruestung, m
                , angriff);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode abwehr muss immer nicht negativen Wert "
                + "liefern (angriff=10)");
        Assertions.assertTrue(((int)erg) <= angriff
            , "Methode abwehr darf Angriffswert nicht vergroessern,"
                + " vorher 10, jetzt " + erg);        
    }

    public static List<Object> szenarien(){
        List<Object> ergebnis = new ArrayList<>();
        for(Object k:kaempfend()){
            for(Object w:waffen()){
                for(Object r:ruestung()){
                    ergebnis.add(new Object[]{k,w,r});
                }
            }
        }
        return ergebnis;
    }
    
    @ParameterizedTest 
    @MethodSource("szenarien")
    // Tests evtl. aufteilen
    public void testKaempfer1(Object kaempfer, Object waffe, Object ruestung){
        Method m = Alle.klasseHatMethodeParametertypenUnbekannt(
                kaempfer.getClass().getSimpleName(), "void"
                , "nimmWaffe", "Waffe").get(0);
        Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, waffe);
        m = Alle.klasseHatMethodeParametertypenUnbekannt(
                kaempfer.getClass().getSimpleName(), "void"
                , "nimmRuestung", "Ruestung").get(0);
        Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, ruestung);
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "kaempfen").get(0);
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode kaempfen muss immer nicht negativen "
                + "Wert liefern");
       
        System.out.println("kaempfer: " + kaempfer);
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "getGesundheit").get(0);
        int gesundheit = (int)Alle.fuehreAufObjektMethodeMitParameternAus(
                kaempfer, m);
        
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class, "abwehren"
                , int.class).get(0);
        int angriff = 0;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");
        gesundheit = (int)erg;
        angriff = 100;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");
    }     
    
    @ParameterizedTest 
    @MethodSource("kaempfend")
    public void testKaempfer2(Object kaempfer){
        Method  m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "kaempfen").get(0);
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode kaempfen muss immer nicht negativen"
                + " Wert liefern");
       
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "getGesundheit").get(0);
        int gesundheit = (int)Alle.fuehreAufObjektMethodeMitParameternAus(
                kaempfer, m);
        
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "abwehren", int.class).get(0);
        int angriff = 0;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");
        gesundheit = (int)erg;
        angriff = 100;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");
    } 
    
    @Test
    public void testSchwarzerRitter(){
        Constructor<?> con = Alle
                .klasseHatKonstruktorParametertypenBekannt("SchwarzerRitter").get(0);
        Object kaempfer = Alle.erzeugeObjektMitKonstruktor(con);
        Method  m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "kaempfen").get(0);
        Object erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m);
        Assertions.assertTrue(((int)erg) >= 0
            , "Methode kaempfen muss immer nicht negativen"
                + " Wert liefern");
       
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "getGesundheit").get(0);
        int gesundheit = (int)Alle.fuehreAufObjektMethodeMitParameternAus(
                kaempfer, m);
        
        m = Alle.klasseHatMethodeParametertypenBekannt(
                kaempfer.getClass().getSimpleName(), int.class
                , "abwehren", int.class).get(0);
        int angriff = 0;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");
        gesundheit = (int)erg;
        angriff = 100;
        erg = Alle.fuehreAufObjektMethodeMitParameternAus(kaempfer, m, angriff);
        Assertions.assertTrue(((int)erg) <= gesundheit
            , "Ein Angriff darf die Gesundheit nicht erhoehen");       
    }
}
