package main;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

import com.github.stefanbirkner.systemlambda.SystemLambda;

public class SystemTest {
    private Main dialog;
    
    //Aufbau: {  {Anzahl Kaempfer}, {waffe, fuer,Waffe, fuer, ...}
    //          ,{ruestung, fuer, ruestung, fuer, ...}, {DuplosenRest} }
    private static int[][][] szenarien = {
                  {{1,0,0},{},{},{480}}
                , {{0,1,0},{},{},{490}}
                , {{0,0,1},{},{},{500}}
                , {{1,0,0},{0,0},{},{450}}
                , {{1,0,0},{1,0},{},{410}}
                , {{1,0,0},{2,0},{},{390}}
                , {{1,0,0},{3,0},{},{360}}
                , {{1,0,0},{},{0,0},{460}}
                , {{1,0,0},{},{1,0},{430}}
                , {{1,0,0},{},{2,0},{410}}
                , {{1,0,0},{},{3,0},{380}}
                , {{1,0,0},{3,0,3,0},{3,0},{140}}
                , {{1,0,0},{3,0,3,0,0,0},{3,0,2,0},{40}}
                , {{0,1,0},{3,0},{},{370}}
                , {{0,1,0},{3,0},{3,0},{270}}
                , {{0,0,1},{3,0,3,0},{3,0},{160}}
                , {{0,0,1},{},{3,0},{400}}
                , {{1,1,1},{3,0,2,1,0,2},{1,0,1,1,0,2},{-90}}
                , {{0,3,0},{3,0,2,1,0,2},{1,0,1,1,0,2},{-90}}
                , {{1,1,0},{2,0,3,1},{3,0,0,1,0,1,0,1},{0}}
    };
    
    @BeforeEach
    public void setUp(){
        this.dialog = new Main();
    }

    private String auswahl(int[][] szene){
        StringBuilder sb = new StringBuilder();
        for(int i=0; i< 3; i++){
            sb.append("Es werden " + szene[0][i]+ " Kaempfer vom Typ " + i + " ausgewaehlt\n");
        }
        for(int i=0; i< szene[1].length; i=i+2){
            sb.append("Kaempfer Nr." + szene[1][i+1] + " erhaelt Waffe " + szene[1][i] + "\n");
        }
        for(int i=0; i< szene[2].length; i=i+2){
            sb.append("Kaempfer Nr." + szene[2][i+1] + " erhaelt Waffe " + szene[2][i] + "\n");
        }
        String erg = sb.append("Es bleiben " + szene[3][0] + " Duplosen").toString();
        return erg;
}
    
    private void ruestung(int wahl, int kaempfer) throws Exception{
        String[] inputs = {""+wahl, ""+kaempfer};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.neueRuestung();
        });
    }
 
    private void waffe(int wahl, int kaempfer) throws Exception{
        String[] inputs = {""+wahl, ""+kaempfer};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.neueWaffe();
        });
    } 
    
    private void soeldner(int wahl) throws Exception{
        String[] inputs = {""+wahl};
        SystemLambda.withTextFromSystemIn(inputs)
        .execute(() -> {
          this.dialog.neuerSoeldner();
        });
    }   
    
    private static int[][][] szenarien(){
        return szenarien;
    }
       
    @ParameterizedTest 
    @MethodSource("szenarien")
    public void testSzenarienstarten(int[][] szene) throws Exception{ 
        this.dialog = new Main(); 
        for(int j=0; j< 3; j++){
            for(int i=0; i< szene[0][j]; i++){
                this.soeldner(j);
            }
        }
        for(int i=0; i< szene[1].length; i=i+2){
            this.waffe(szene[1][i], szene[1][i+1]);
        }
        for(int i=0; i< szene[2].length; i=i+2){
            this.ruestung(szene[2][i], szene[2][i+1]);
        }
        Assertions.assertEquals(szene[3][0], this.dialog.getDuplosen()
            , this.auswahl(szene));               
    }
    
    @Test
    public void testDurchlaufendesSpiel() throws Exception{
        String[] inputs = {"1","0","1","1","2","2","0","2","3","1"
                ,"3","3","0","3","0","1","3","0","1","3","0","1","0"};
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.starten();
          });
        });
        
        Assertions.assertTrue(systemOut.contains(Messages.getString("Main.25"))
            , "Einfaches Spiel lauft nicht durch.");
    }
    
    @Test
    public void testNichtDurchlaufendesSpiel() throws Exception{
        String[] inputs = {"1","0","1","1","2","2","0","2","3","1"
                ,"3","3","0","3","0","1","3","0","1","3","0","1","3","0","1"};
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.starten();
          });
        });
        Assertions.assertTrue(systemOut.contains(Messages.getString("Main.16"))
            , "Zuviel Geld ausgegeben, Spiel laeuft trotzdem.");
    }       
}
