package main;

import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.github.stefanbirkner.systemlambda.SystemLambda;

public class SystemTest {
        
    private Dialog dialog;
    
    @BeforeEach
    public void setUp(){
        this.dialog = new Dialog();
    }
    
    private void studentHinzu(int mat, String name) throws Exception{
        String[] inputs = {""+mat, name};
        SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.newStudent();
        });
    }
    
    private void studentLoeschen(int mat) throws Exception{
        String[] inputs = {""+mat};
        SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.removeStudent();
        });      
    }
    
    private void studentSuchen(int mat) throws Exception{
        String[] inputs = {""+mat};
        SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.searchStudent();
        });
    }
    
    @Test
    public void testErsterStudent() throws Exception{
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentHinzu(42, "Ute Utemeier");
        });
        Assertions.assertTrue(Pattern.matches("(?s).*student added.*"
                                , systemOut)
                , "Student sollte hinzugefuegt sein: 42 Ute Utemeier: "
                        + systemOut);
    }
    
    @Test
    public void testKeineDoppeltenStudenten() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentHinzu(42, "Ute Utemeier");
        });
        Assertions.assertTrue( Pattern.matches("(?s).*student not added.*"
                        , systemOut)
            , "Student sollte nicht hinzugefuegt sein: 42 Ulf Utemeier: "
                + systemOut);
    }  
    
    @Test
    public void testStudentErfolgreichZeigen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(43, "Ulf Schmidt");
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.dialog.showCourse();
        });
        Assertions.assertTrue(Pattern.matches("(?s).*42.*Ute.*Utemeier.*"
                        , systemOut)
            ,"Student sollte vorhanden sein: 42 Ute Utemeier: "
                        + systemOut);
        Assertions.assertTrue(Pattern.matches("(?s).*43.*Ulf.*Schmidt.*"
                        , systemOut)
            , "Student sollte vorhanden sein: 43 Ulf Schmidt: "
                        + systemOut);        
    }
    
    @Test
    public void testExistierendenStudentLoeschen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(43, "Ulf Schmidt");
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentLoeschen(42);
        });
        Assertions.assertTrue(Pattern.matches("(?s).*student removed.*"
                        , systemOut)
            , "Student sollte geloescht sein: 42 Ute Utemeier: "
                        + systemOut);     
    } 

    @Test
    public void testNichtExistierendenStudentLoeschen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(43, "Ulf Schmidt");
        this.studentLoeschen(42);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentLoeschen(42);
        });
        Assertions.assertTrue(Pattern.matches("(?s).*student not removed.*"
                        , systemOut)
            , "Student sollte nicht mehr loeschbar sein: 42 Ute Utemeier: "
                        + systemOut);     
    }    
    
    
    @Test
    public void testExistierendenStudentLoeschenUndAnzeigen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(43, "Ulf Schmidt");
        this.studentLoeschen(42);
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.dialog.showCourse();
        });
        Assertions.assertFalse(Pattern.matches("(?s).*42.*Ute.*Utemeier.*"
                        , systemOut)
            , "Student sollte nicht vorhanden sein: 42 Ute Utemeier: "
                        + systemOut);
        Assertions.assertTrue(Pattern.matches("(?s).*43.*Ulf.*Schmidt.*"
                        , systemOut)
            , "Student sollte vorhanden sein: 43 Ulf Schmidt: "
                        + systemOut);        
    }    
    
    @Test
    public void testExistierendenStudentSuchen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(43, "Ulf Schmidt");   
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentSuchen(43);
        });
        Assertions.assertTrue(Pattern.matches("(?s).*43.*Ulf.*Schmidt.*"
                        , systemOut)
            , "Student sollte gefunden werden: 43 Ulf Schmidt: "
                        + systemOut);
    }
    
    @Test
    public void testNichtExistierendenStudentSuchen() throws Exception{
        this.studentHinzu(42, "Ute Utemeier");
        this.studentHinzu(44, "Ulf Schmidt");   
        String systemOut = SystemLambda.tapSystemOutNormalized(() -> {
          this.studentSuchen(43);
        });
        Assertions.assertTrue(Pattern.matches("(?s).*student not found.*"
                        , systemOut)
            , "Student sollte nicht gefunden werden: 43 Ulf Schmidt: "
                        + systemOut);
    }
    
    @Test
    public void testDialogVollstaendigDurchlaufen() throws Exception{
//        String[] inputs = {"1", "73", "Sergej Ob"
//                , "1", "74", "Anna Zusic"
//                , "1", "73", "Heinz Meier"
//                , "3", "74"
//                , "3", "42"
//                , "4"
//                , "2", "73"
//                , "2", "73"
//                , "0"};
//        SystemLambda.withTextFromSystemIn(inputs)
//      .execute(() -> {
//        this.dialog.control();
//      });
        String ausgabe = SystemLambda.tapSystemOutNormalized(() -> {
          String[] inputs = {"1", "73", "Sergej Ob"
                    , "1", "74", "Anna Zusic"
                    , "1", "73", "Heinz Meier"
                    , "3", "74"
                    , "3", "42"
                    , "4"
                    , "2", "73"
                    , "2", "73"
                    , "0"};
            SystemLambda.withTextFromSystemIn(inputs)
          .execute(() -> {
            this.dialog.control();
          });
        });
        Assertions.assertTrue(Pattern.matches("(?s)(.*student added.*){2}", ausgabe)
            , "Zwei Studenten sollten erfolgreich hinzugefuegt werden: "
                        + ausgabe);
        Assertions.assertTrue(Pattern.matches("(?s).*student not added.*", ausgabe)
            , "Ein Student sollte nicht erfolgreich hinzugefuegt werden: "
                        + ausgabe);
        Assertions.assertTrue(Pattern.matches("(?s)(.*74.*Anna.*Zusic.*){2}", ausgabe)
            , "Ein Student sollte erfolgreich gefunden und ausgegeben werden: "
                        + ausgabe);
        Assertions.assertTrue(Pattern.matches("(?s).*73.*Sergej.*Ob.*", ausgabe)
            , "Ein Student sollte erfolgreich ausgegeben werden: "
                        + ausgabe);        
        Assertions.assertTrue(Pattern.matches("(?s).*student not found.*", ausgabe),
            "Ein Student nicht gefunden werden: "
                        + ausgabe);
        Assertions.assertTrue(Pattern.matches("(?s).*student removed.*", ausgabe),
            "Ein Student sollte erfolgreich geloescht werden: "
                        + ausgabe);
        Assertions.assertTrue(Pattern.matches("(?s).*student not removed.*", ausgabe),
            "Ein Student konnte nicht geloescht werden: "
                        + ausgabe);
    }    
}
