package entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Doppelliste implements Cloneable{

  private List<Punkt> liste1;
  private List<Punkt> liste2;
  
  public Doppelliste(){
    this.liste1 = new ArrayList<>();
    this.liste2 = new ArrayList<>();
  }

  public Doppelliste(List<Punkt> liste1, List<Punkt> liste2) {
    super();
    this.liste1 = liste1;
    this.liste2 = liste2;
  }
  
 //so geht eine tiefe Kopie nicht
  @Override
  public Doppelliste clone(){
    return this;
  }
  
  public List<Punkt> getListe1() {
    return liste1;
  }

  public void setListe1(List<Punkt> liste1) {
    this.liste1 = liste1;
  }

  public List<Punkt> getListe2() {
    return liste2;
  }

  public void setListe2(List<Punkt> liste2) {
    this.liste2 = liste2;
  }

  @Override
  public int hashCode() {
    return Objects.hash(liste1, liste2);
  }


  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    Doppelliste other = (Doppelliste) obj;
    return Objects.equals(liste1, other.liste1)
        && Objects.equals(liste2, other.liste2);
  }

  @Override
  public String toString() {
    return "Doppelliste [liste1=" + liste1 + ", liste2=" + liste2 + "]";
  }
  
  
}
