import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EqualsUndCloneTest {
  
  private Mitarbeitend mNull;
  private Mitarbeitend m1;
  private Mitarbeitend m2;
  private Pairprogramming pNullNull;
  private Pairprogramming pNullOk;
  private Pairprogramming pOkNull;
  private Pairprogramming p1;
  private Pairprogramming p2;
  
  @BeforeEach
  public void setUp(){
    this.mNull = new Mitarbeitend(0, null);
    this.m1 = new Mitarbeitend(1,"Leila");
    this.m2 = new Mitarbeitend(2,"Murat");
    this.pNullNull = new Pairprogramming(null, null);
    this.pNullOk = new Pairprogramming(null, m1);
    this.pOkNull = new Pairprogramming(m1, null);
    this.p1 = new Pairprogramming(m1, m2);  
    this.p2 = new Pairprogramming(mNull, mNull);
  }
  
  @Test
  public void testMitarbeiterGleichheitErwartet1(){
    Mitarbeitend tmp = new Mitarbeitend(0, null);
    Assertions.assertTrue(this.mNull.equals(tmp));
  }
  
  @Test
  public void testMitarbeiterGleichheitErwartet2(){
    Mitarbeitend tmp = new Mitarbeitend(2,"Murat");
    Assertions.assertTrue(this.m2.equals(tmp));
  }
  
  @Test
  public void testMitarbeiterGleichheitNichtErwartet1(){
    Mitarbeitend tmp = new Mitarbeitend(1, null);
    Assertions.assertTrue(!this.mNull.equals(tmp));
  }
  
  @Test
  public void testMitarbeiterGleichheitNichtErwartet2(){
    Mitarbeitend tmp = new Mitarbeitend(22,"Murat");
    Assertions.assertTrue(!this.m2.equals(tmp));
  }

  @Test  
  public void testMitarbeiterClone1(){
    Mitarbeitend tmp = m1.clone();
    Assertions.assertTrue(this.m1.equals(tmp));
    Assertions.assertTrue(tmp != this.m1);
  }
  
  @Test  
  public void testMitarbeiterClone2(){
    Mitarbeitend tmp = mNull.clone();
    Assertions.assertTrue(this.mNull.equals(tmp));
    Assertions.assertTrue(tmp != this.mNull);
  }
  
  @Test
  public void testPairprogrammerGleichheitErwartet1(){
    Pairprogramming tmp = new Pairprogramming(null,null);
    Assertions.assertTrue(this.pNullNull.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitErwartet2(){
    Pairprogramming tmp = new Pairprogramming(null,this.m1.clone());
    Assertions.assertTrue(this.pNullOk.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitErwartet3(){
    Pairprogramming tmp = new Pairprogramming(m1.clone(),null);
    Assertions.assertTrue(this.pOkNull.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitErwartet4(){
    Pairprogramming tmp = new Pairprogramming(m1.clone(), m2.clone());
    Assertions.assertTrue(this.p1.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitErwartet5(){
    Pairprogramming tmp = new Pairprogramming(mNull.clone(), mNull.clone());
    Assertions.assertTrue(this.p2.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet1(){
    Pairprogramming tmp = new Pairprogramming(null,m2);
    Assertions.assertTrue(!this.pNullNull.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet2(){
    Pairprogramming tmp = new Pairprogramming(null,this.m1.clone());
    tmp.getMitglied2().setMinr(73);
    Assertions.assertTrue(!this.pNullOk.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet3(){
    Pairprogramming tmp = new Pairprogramming(m1.clone(),null);
    tmp.getMitglied1().setMinr(73);
    Assertions.assertTrue(!this.pOkNull.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet4(){
    Pairprogramming tmp = new Pairprogramming(m1.clone(), m2.clone());
    tmp.getMitglied1().setMinr(73);
    Assertions.assertTrue(!this.p1.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet5(){
    Pairprogramming tmp = new Pairprogramming(m1.clone(), m2.clone());
    tmp.getMitglied2().setMinr(73);
    Assertions.assertTrue(!this.p1.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet6(){
    Pairprogramming tmp = new Pairprogramming(mNull.clone(), mNull.clone());
    tmp.getMitglied1().setMinr(73);
    Assertions.assertTrue(!this.p2.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerGleichheitNichtErwartet7(){
    Pairprogramming tmp = new Pairprogramming(mNull.clone(), mNull.clone());
    tmp.getMitglied2().setMinr(73);
    Assertions.assertTrue(!this.p2.equals(tmp));
  }
  
  @Test
  public void testPairprogrammerClone1(){
    Pairprogramming tmp = this.pNullNull.clone();
    Assertions.assertTrue(tmp.equals(this.pNullNull));
    Assertions.assertTrue(tmp != this.pNullNull);
    // == da es sich um null-Werte handelt
    Assertions.assertTrue(tmp.getMitglied1() == this.pNullNull.getMitglied1());
    Assertions.assertTrue(tmp.getMitglied2() == this.pNullNull.getMitglied2());
  }
    
  @Test
  public void testPairprogrammerClone2(){
    Pairprogramming tmp = this.pNullOk.clone();
    Assertions.assertTrue(tmp.equals(this.pNullOk));
    Assertions.assertTrue(tmp != this.pNullOk);
    Assertions.assertTrue(tmp.getMitglied1() == this.pNullOk.getMitglied1());
    Assertions.assertTrue(tmp.getMitglied2() != this.pNullOk.getMitglied2());
  }
  
  @Test
  public void testPairprogrammerClone3(){
    Pairprogramming tmp = this.pOkNull.clone();
    Assertions.assertTrue(tmp.equals(this.pOkNull));
    Assertions.assertTrue(tmp != this.pOkNull);
    Assertions.assertTrue(tmp.getMitglied1() != this.pOkNull.getMitglied1());
    Assertions.assertTrue(tmp.getMitglied2() == this.pOkNull.getMitglied2());
  }
  
  @Test
  public void testPairprogrammerClone4(){
    Pairprogramming tmp = this.p1.clone();
    Assertions.assertTrue(tmp.equals(this.p1));
    Assertions.assertTrue(tmp != this.p1);
    Assertions.assertTrue(tmp.getMitglied1() != this.p1.getMitglied1());
    Assertions.assertTrue(tmp.getMitglied2() != this.p1.getMitglied2());
  }
  
  @Test
  public void testPairprogrammerClone5(){
    Pairprogramming tmp = this.p2.clone();
    Assertions.assertTrue(tmp.equals(this.p2));
    Assertions.assertTrue(tmp != this.p2);
    Assertions.assertTrue(tmp.getMitglied1() != this.p1.getMitglied1());
    Assertions.assertTrue(tmp.getMitglied2() != this.p1.getMitglied2());
  }
  
}
