import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

/* Anders als die anderen Klassen in diesem Projekt, muss dies nicht
 * verstanden werden. Sie dient ausschliesslich der Bequemlichkeit,
 * alle Tests nacheinander zusammen auszufuehren. Es wird eine
 * Zusammenfassung ausgegeben, wie viele Tests laufen und
 * welche nicht.
 * Klasse wurde ergaenzt, da BlueJ keine TestSuites unterstuetzt (?).
 */
public class AllTest {

  // Quelle: https://www.programcreek.com/java-api-examples/?code=btdex%2Fbtdex%2Fbtdex-master%2Fsrc%2Ftest%2Fjava%2Fbtdex%2FRunSellContractTests.java
  public static void executeAllTests() {
    LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request()
            .selectors(
                DiscoverySelectors.selectClass(MessreiheAlleEinmalTest.class)
                , DiscoverySelectors.selectClass(MessreiheGemeinsameEinfachTest.class)
            )
            .build();

    Launcher launcher = LauncherFactory.create();
    SummaryGeneratingListener listener = new SummaryGeneratingListener();
    launcher.registerTestExecutionListeners(listener);
    launcher.execute(request);

    TestExecutionSummary summary = listener.getSummary();
    printReport(summary);

  }
  
  private static void printReport(TestExecutionSummary summary) {
    System.out.println(
            "\n------------------------------------------" +
                    "\nTests started: " + summary.getTestsStartedCount() +
                    "\nTests failed: " + summary.getTestsFailedCount() +
                    "\nTests succeeded: " + summary.getTestsSucceededCount() +
                    "\n------------------------------------------"
    );

    if(summary.getTestsFailedCount() > 0) {
        for(TestExecutionSummary.Failure f: summary.getFailures()){
            System.out.println(f.getTestIdentifier().getSource() +
                                "\nException " + f.getException());
        }
    }
  }
}

