import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import java.util.ArrayList;

public class MessreiheAlleEinmalTest{
    
    private Messreihe m33244;
    private Messreihe m43243;
    private Messreihe m234;
    private Messreihe m432432;
    private Messreihe m332445;
    private Messreihe m3;
    private Messreihe leer;
    private Messreihe mitNullListe;
    private ArrayList<Integer> genutzt;

  private void merkeGenutzteWerte(Messreihe m){
    if (m.getMesswerte() == null){
      return;
    }
    for (int w: m.getMesswerte()) { // in Messreihe keine null-Werte
      this.genutzt.add(w);
    }
  }
  
  private boolean messwerteUnveraendert(Messreihe m){
    if (m.getMesswerte() == null){
      return this.genutzt.size() == 0;
    }
    for(int i = 0; i < this.genutzt.size(); i++) {
      if (this.genutzt.get(i) != m.getMesswerte().get(i)){
        return false;
      }
    }
    return m.getMesswerte().size() == this.genutzt.size();
  }
  
    @BeforeEach
      public void setUp() {
        this.genutzt = new ArrayList<Integer>();
        this.m33244 = new Messreihe("Ort1");
        this.m33244.hinzufuegen(3);
        this.m33244.hinzufuegen(3);
        this.m33244.hinzufuegen(2);
        this.m33244.hinzufuegen(4);
        this.m33244.hinzufuegen(4);
        this.m43243 = new Messreihe("Ort2");
        this.m43243.hinzufuegen(4);
        this.m43243.hinzufuegen(3);
        this.m43243.hinzufuegen(2);
        this.m43243.hinzufuegen(4);
        this.m43243.hinzufuegen(3);
        this.m234 = new Messreihe("Ort3");
        this.m234.hinzufuegen(2);
        this.m234.hinzufuegen(3);
        this.m234.hinzufuegen(4);
        this.m432432 = new Messreihe("Ort22");
        this.m432432.hinzufuegen(4);
        this.m432432.hinzufuegen(3);
        this.m432432.hinzufuegen(2);
        this.m432432.hinzufuegen(4);
        this.m432432.hinzufuegen(3);
        this.m432432.hinzufuegen(2);
        this.m332445 = new Messreihe("Ort11");
        this.m332445.hinzufuegen(3);
        this.m332445.hinzufuegen(3);
        this.m332445.hinzufuegen(2);
        this.m332445.hinzufuegen(4);
        this.m332445.hinzufuegen(4);
        this.m332445.hinzufuegen(5);
        this.m3 = new Messreihe("Ort12");
        this.m3.hinzufuegen(3);
        this.leer = new Messreihe("Ort4");
        this.mitNullListe = new Messreihe("Ort5");
        this.mitNullListe.setMesswerte(null);
    }

    @Test
    public void test01(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " erwartet wurden 3 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , this.m33244 + " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m33244 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , this.m33244 + " erwartet wurde eine 4, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m33244);        
    }

    @Test
    public void test02(){
        this.merkeGenutzteWerte(this.m43243);
        Messreihe tmp = this.m43243.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m43243 + " erwartet wurden 3 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , this.m43243 + " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m43243 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , this.m43243 + " erwartet wurde eine 4, gefunden: " + tmp);  
        Assertions.assertTrue(this.messwerteUnveraendert(this.m43243)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m43243);        
    }
    
    @Test
    public void test03(){
        this.merkeGenutzteWerte(this.m234);
        Messreihe tmp = this.m234.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m234 + " erwartet wurden 3 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , this.m234 + " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m234 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , this.m234 + " erwartet wurde eine 4, gefunden: " + tmp);  
        Assertions.assertTrue(this.messwerteUnveraendert(this.m234)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m234);    
    }
    
    @Test
    public void test04(){
        this.merkeGenutzteWerte(this.m432432);
        Messreihe tmp = this.m432432.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m432432 + " erwartet wurden 3 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , this.m432432 + " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m432432 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , this.m432432 + " erwartet wurde eine 4, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(this.m432432)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m432432);        
    }
    
    @Test
    public void test05(){
        this.merkeGenutzteWerte(this.m332445);
        Messreihe tmp = this.m332445.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 4
            , this.m332445 + " erwartet wurden 4 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , this.m332445 + " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m332445 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , this.m332445 + " erwartet wurde eine 4, gefunden: " + tmp);  
        Assertions.assertTrue(tmp.getMesswerte().contains(5)
            , this.m332445 + " erwartet wurde eine 5, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(this.m332445)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m332445);        
    }
    
    @Test
    public void test06(){
        this.merkeGenutzteWerte(this.m3);
        Messreihe tmp = this.m3.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 1
            , this.m3 + " erwartet wurden 1 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , this.m3 + " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m3)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.m3);    
    }
    
    @Test
    public void test07(){
        this.merkeGenutzteWerte(this.leer);
        Messreihe tmp = this.leer.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.leer + " erwartet wurden 0 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.leer)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.leer);            
    }
    
    @Test
    public void test08(){
        this.merkeGenutzteWerte(this.mitNullListe);
        Messreihe tmp = this.mitNullListe.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.mitNullListe + " erwartet wurden 0 Werte, gefunden: " 
                + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.mitNullListe)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + this.mitNullListe);            
    }
    
    @Test
    public void testneu(){
        Messreihe m = new Messreihe("");
        m.hinzufuegen(30);
        m.hinzufuegen(70);
        m.hinzufuegen(20);
        m.hinzufuegen(30);
        m.hinzufuegen(30);
        m.hinzufuegen(30);
        m.hinzufuegen(70);
        m.hinzufuegen(20);
        this.merkeGenutzteWerte(m);
        Messreihe tmp = m.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , m + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(20)
            , m + " erwartet wurde eine 20, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(30)
            , m + " erwartet wurde eine 30, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(70)
            , m + " erwartet wurde eine 70, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(m)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + m);        
    }
    
    @Test
    public void testneu2(){
        Messreihe m = new Messreihe("");
        m.hinzufuegen(30);
        m.hinzufuegen(30);
        m.hinzufuegen(30);
        m.hinzufuegen(30);
        this.merkeGenutzteWerte(m);
        Messreihe tmp = m.alleEinmal();
        Assertions.assertTrue(tmp.getMesswerte().size() == 1
            , m + " erwartet wurde 1 Wert, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(30)
            , m + " erwartet wurde eine 30, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(m)
            , "urspruengliche Werte " + this.genutzt 
              + " sollten nicht geaendert werden:" + m);        
    }
}
