import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import java.util.ArrayList;

public class MessreiheGemeinsameEinfachTest{
    
    private Messreihe m33244;
    private Messreihe m43243;
    private Messreihe m234;
    private Messreihe m332445;
    private Messreihe m3;
    private Messreihe leer;
    private Messreihe mitNullListe;
    private ArrayList<Integer> genutzt;

  private void merkeGenutzteWerte(Messreihe m){
    if (m.getMesswerte() == null){
      return;
    }
    for (int w: m.getMesswerte()) { // in Messreihe keine null-Werte
      this.genutzt.add(w);
    }
  }
  
  private boolean messwerteUnveraendert(Messreihe m){
    if (m.getMesswerte() == null){
      return this.genutzt.size() == 0;
    }
    for(int i = 0; i < this.genutzt.size(); i++) {
      if (this.genutzt.get(i) != m.getMesswerte().get(i)){
        return false;
      }
    }
    return m.getMesswerte().size() == this.genutzt.size();
  }
  
    @BeforeEach
    public void setUp() {
        this.genutzt = new ArrayList<Integer>();
        this.m33244 = new Messreihe("Ort1");
        this.m33244.hinzufuegen(3);
        this.m33244.hinzufuegen(3);
        this.m33244.hinzufuegen(2);
        this.m33244.hinzufuegen(4);
        this.m33244.hinzufuegen(4);
        this.m43243 = new Messreihe("Ort2");
        this.m43243.hinzufuegen(4);
        this.m43243.hinzufuegen(3);
        this.m43243.hinzufuegen(2);
        this.m43243.hinzufuegen(4);
        this.m43243.hinzufuegen(3);
        this.m234 = new Messreihe("Ort3");
        this.m234.hinzufuegen(2);
        this.m234.hinzufuegen(3);
        this.m234.hinzufuegen(4);
        this.m332445 = new Messreihe("Ort11");
        this.m332445.hinzufuegen(3);
        this.m332445.hinzufuegen(3);
        this.m332445.hinzufuegen(2);
        this.m332445.hinzufuegen(4);
        this.m332445.hinzufuegen(4);
        this.m332445.hinzufuegen(5);
        this.m3 = new Messreihe("Ort12");
        this.m3.hinzufuegen(3);
        this.leer = new Messreihe("Ort4");
        this.mitNullListe = new Messreihe("Ort5");
        this.mitNullListe.setMesswerte(null);
    }

    @Test
    public void test01(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m33244);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " und " + this.m33244 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m33244);
    }
    
    @Test
    public void test02(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m43243);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " und " + this.m43243 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m33244);    
    }
    
    @Test
    public void test02b(){
        this.merkeGenutzteWerte(this.m43243);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m43243);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " und " + this.m43243 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp); 
        Assertions.assertTrue(this.messwerteUnveraendert(this.m43243)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m43243);    
    }
    
    @Test
    public void test03(){
        this.merkeGenutzteWerte(this.m43243);
        Messreihe tmp = this.m43243.gemeinsameEinfach(this.m33244);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m43243 + " und " + this.m33244 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m43243)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m43243);
    }
    
    @Test
    public void test04(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m234);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " und " + this.m234 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m33244);    
    }
    
    @Test
    public void test05(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m332445);
        Assertions.assertTrue(tmp.getMesswerte().size() == 3
            , this.m33244 + " und " + this.m332445 
              + " erwartet wurden 3 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(2)
            , " erwartet wurde eine 2, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(tmp.getMesswerte().contains(4)
            , " erwartet wurde eine 4, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m33244);    
    }
    
    @Test
    public void test06(){
        this.merkeGenutzteWerte(this.m33244);
        Messreihe tmp = this.m33244.gemeinsameEinfach(this.m3);
        Assertions.assertTrue(tmp.getMesswerte().size() == 1
            , this.m33244 + " und " + this.m3 
              + " erwartet wurden 1 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m33244)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m33244);      
    }
    
    @Test
    public void test07(){
        this.merkeGenutzteWerte(this.m3);
        Messreihe tmp = this.m3.gemeinsameEinfach(this.m33244);
        Assertions.assertTrue(tmp.getMesswerte().size() == 1
            , this.m3 + " und " + this.m33244 
              + " erwartet wurden 1 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(tmp.getMesswerte().contains(3)
            , " erwartet wurde eine 3, gefunden: " + tmp);
        Assertions.assertTrue(this.messwerteUnveraendert(this.m3)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m3);    
    }   
    
    @Test
    public void test08(){
        this.merkeGenutzteWerte(this.leer);
        Messreihe tmp = this.leer.gemeinsameEinfach(this.m3);
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.leer + " und " + this.m3 
              + " erwartet wurden 0 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.leer)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.leer);      
    }   
    
    @Test
    public void test09(){
        this.merkeGenutzteWerte(this.m3);
        Messreihe tmp = this.m3.gemeinsameEinfach(this.leer);
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.m3 + " und " + this.leer 
              + " erwartet wurden 0 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.m3)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m3);      
    }  
    
    @Test
    public void test10(){
        Messreihe m4 = new Messreihe("XYZ");
        m4.hinzufuegen(4);
        this.merkeGenutzteWerte(this.m3);
        Messreihe tmp = this.m3.gemeinsameEinfach(m4);
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.m3 + " und " + m4 
              + " erwartet wurden 0 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.m3)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m3);      
    }
    
    @Test
    public void test11(){
        this.merkeGenutzteWerte(this.mitNullListe);
        Messreihe tmp = this.mitNullListe.gemeinsameEinfach(this.m3);
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.mitNullListe + " und " + this.m3 
              + " erwartet wurden 0 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.mitNullListe)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.mitNullListe);
    }   
    
    @Test
    public void test12(){
        this.merkeGenutzteWerte(this.m3);
        Messreihe tmp = this.m3.gemeinsameEinfach(this.mitNullListe);
        Assertions.assertTrue(tmp.getMesswerte().size() == 0
            , this.m3 + " und " + this.mitNullListe 
              + " erwartet wurden 0 Werte, gefunden: " + tmp.getMesswerte());
        Assertions.assertTrue(this.messwerteUnveraendert(this.m3)
            , "urspruengliche Werte " + this.genutzt 
                + " sollten nicht geaendert werden:" + this.m3);      
    }     
}
